/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.idl.TypeUtil;
import io.stargate.graphql.schema.graphqlfirst.processor.ArgumentDirectiveModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IncrementModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IncrementModelBuilder
extends ArgumentDirectiveModelBuilderBase<IncrementModel> {
    private static final List<String> COUNTER_INCREMENT_TYPES = ImmutableList.of((Object)Scalars.GraphQLInt.getName(), (Object)CqlScalar.BIGINT.getGraphqlType().getName(), (Object)CqlScalar.COUNTER.getGraphqlType().getName());
    private static final boolean PREPEND_DEFAULT = false;

    public IncrementModelBuilder(InputValueDefinition argument, Optional<Directive> directive, EntityModel entity, FieldModel field, String operationName, Map<String, EntityModel> entities, ProcessingContext context) {
        super(argument, directive, entity, field, operationName, entities, context);
    }

    @Override
    IncrementModel build() throws SkipException {
        boolean prepend = this.directive.flatMap(d -> DirectiveHelper.getBooleanArgument(d, "prepend", this.context)).orElse(false);
        this.validate(this.field, prepend);
        return new IncrementModel(this.field, prepend, this.argument.getName());
    }

    protected void validate(FieldModel field, boolean prepend) throws SkipException {
        if (field.isPartitionKey() || field.isClusteringColumn()) {
            this.invalidMapping("Operation %s: directive %s is not supported for partition/clustering key field %s.", new Object[]{this.operationName, "cql_increment", field.getGraphqlName()});
            throw SkipException.INSTANCE;
        }
        Type<?> fieldInputType = this.fieldInputType();
        if (this.isCounter(fieldInputType)) {
            if (prepend) {
                this.failOnInvalidPrepend();
            }
            if (!this.argumentIsValidCounterIncrementType()) {
                this.invalidMapping("Operation %s: expected argument %s to have a valid counter increment type (one of: %s)", new Object[]{this.operationName, this.argument.getName(), Joiner.on((String)", ").join(COUNTER_INCREMENT_TYPES)});
                throw SkipException.INSTANCE;
            }
        } else if (TypeUtil.isList(fieldInputType)) {
            Type<?> argumentType;
            if (field.getCqlType().isSet() && prepend) {
                this.failOnInvalidPrepend();
            }
            if (!TypeHelper.deepEquals(argumentType = TypeHelper.unwrapNonNull(this.argument.getType()), fieldInputType)) {
                this.invalidMapping("Operation %s: expected argument %s to have type: %s to match %s.%s", new Object[]{this.operationName, this.argument.getName(), TypeHelper.format(fieldInputType), this.entity.getGraphqlName(), field.getGraphqlName()});
                throw SkipException.INSTANCE;
            }
        } else {
            this.invalidMapping("Operation %s: @%s can only be applied to counter or collection fields", new Object[]{this.operationName, "cql_increment"});
            throw SkipException.INSTANCE;
        }
    }

    private boolean isCounter(Type<?> type) {
        return type instanceof TypeName && CqlScalar.COUNTER.getGraphqlType().getName().equals(((TypeName)type).getName());
    }

    private void failOnInvalidPrepend() throws SkipException {
        this.invalidMapping("Operation %s: @%s.%s can only be applied to list fields", new Object[]{this.operationName, "cql_increment", "prepend"});
        throw SkipException.INSTANCE;
    }

    private boolean argumentIsValidCounterIncrementType() {
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        if (argumentType instanceof TypeName) {
            String argumentTypeName = ((TypeName)argumentType).getName();
            for (String allowedTypeName : COUNTER_INCREMENT_TYPES) {
                if (!argumentTypeName.equals(allowedTypeName)) continue;
                return true;
            }
        }
        return false;
    }
}

