/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.language.SourceLocation;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.stargate.db.Persistence;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingLogType;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingMessage;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

class ProcessingContext {
    private final TypeDefinitionRegistry typeRegistry;
    private final Keyspace keyspace;
    private final Persistence persistence;
    private final boolean isPersisted;
    private final EnumSet<CqlScalar> usedCqlScalars = EnumSet.noneOf(CqlScalar.class);
    private final List<ProcessingMessage<ProcessingLogType>> logs;
    private final List<ProcessingMessage<ProcessingErrorType>> errors;

    ProcessingContext(TypeDefinitionRegistry typeRegistry, Keyspace keyspace, Persistence persistence, boolean isPersisted) {
        this.typeRegistry = typeRegistry;
        this.keyspace = keyspace;
        this.persistence = persistence;
        this.isPersisted = isPersisted;
        this.logs = new ArrayList<ProcessingMessage<ProcessingLogType>>();
        this.errors = new ArrayList<ProcessingMessage<ProcessingErrorType>>();
    }

    TypeDefinitionRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    Keyspace getKeyspace() {
        return this.keyspace;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    EnumSet<CqlScalar> getUsedCqlScalars() {
        return this.usedCqlScalars;
    }

    @FormatMethod
    void addInfo(SourceLocation location, @FormatString String format, Object ... arguments) {
        this.logs.add(ProcessingMessage.log(location, ProcessingLogType.Info, format, arguments));
    }

    @FormatMethod
    void addWarning(SourceLocation location, @FormatString String format, Object ... arguments) {
        this.logs.add(ProcessingMessage.log(location, ProcessingLogType.Warning, format, arguments));
    }

    @FormatMethod
    void addError(SourceLocation location, ProcessingErrorType messageType, @FormatString String format, Object ... arguments) {
        this.errors.add(ProcessingMessage.error(location, messageType, format, arguments));
    }

    List<ProcessingMessage<ProcessingLogType>> getLogs() {
        return this.logs;
    }

    List<ProcessingMessage<ProcessingErrorType>> getErrors() {
        return this.errors;
    }
}

