/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.Scalars;
import graphql.language.FieldDefinition;
import graphql.language.TypeName;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.EnumSet;
import java.util.Optional;

public class ResponsePayloadModel
implements OperationModel.ReturnType {
    private final Optional<EntityField> entityField;
    private final EnumSet<TechnicalField> technicalFields;

    public ResponsePayloadModel(Optional<EntityField> entityField, EnumSet<TechnicalField> technicalFields) {
        this.entityField = entityField;
        this.technicalFields = technicalFields;
    }

    public Optional<EntityField> getEntityField() {
        return this.entityField;
    }

    @Override
    public Optional<EntityModel> getEntity() {
        return this.getEntityField().map(EntityField::getEntity);
    }

    @Override
    public boolean isList() {
        return this.getEntityField().map(EntityField::isList).orElse(false);
    }

    public EnumSet<TechnicalField> getTechnicalFields() {
        return this.technicalFields;
    }

    public static enum TechnicalField {
        APPLIED("applied", Scalars.GraphQLBoolean.getName()),
        PAGING_STATE("pagingState", Scalars.GraphQLString.getName());

        private final String graphqlName;
        private final TypeName typeName;

        private TechnicalField(String graphqlName, String typeName) {
            this.graphqlName = graphqlName;
            this.typeName = TypeName.newTypeName((String)typeName).build();
        }

        public String getGraphqlName() {
            return this.graphqlName;
        }

        static TechnicalField matching(FieldDefinition field) {
            for (TechnicalField value : TechnicalField.values()) {
                if (!value.matches(field)) continue;
                return value;
            }
            return null;
        }

        private boolean matches(FieldDefinition field) {
            return this.graphqlName.equals(field.getName()) && TypeHelper.deepEquals(this.typeName, TypeHelper.unwrapNonNull(field.getType()));
        }
    }

    public static class EntityField {
        private final String name;
        private final EntityModel entity;
        private final boolean isList;

        public EntityField(String name, EntityModel entity, boolean isList) {
            this.name = name;
            this.entity = entity;
            this.isList = isList;
        }

        public String getName() {
            return this.name;
        }

        public EntityModel getEntity() {
            return this.entity;
        }

        public boolean isList() {
            return this.isList;
        }
    }
}

