/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.util;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.LinkedHashMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DirectedGraph<VertexT> {
    private final Map<VertexT, Integer> predecessorCounts;
    private final Multimap<VertexT, VertexT> adjacencyList;
    private boolean wasSorted;

    public DirectedGraph(Collection<VertexT> vertices) {
        this.predecessorCounts = Maps.newLinkedHashMapWithExpectedSize((int)vertices.size());
        this.adjacencyList = LinkedHashMultimap.create();
        for (VertexT vertex : vertices) {
            this.predecessorCounts.put(vertex, 0);
        }
    }

    @SafeVarargs
    @VisibleForTesting
    DirectedGraph(VertexT ... vertices) {
        this((Collection<VertexT>)Arrays.asList(vertices));
    }

    public void addEdge(VertexT from, VertexT to) {
        Preconditions.checkState((!this.wasSorted ? 1 : 0) != 0);
        Preconditions.checkArgument((this.predecessorCounts.containsKey(from) && this.predecessorCounts.containsKey(to) ? 1 : 0) != 0);
        this.adjacencyList.put(from, to);
        this.predecessorCounts.put(to, this.predecessorCounts.get(to) + 1);
    }

    public List<VertexT> topologicalSort() {
        Preconditions.checkState((!this.wasSorted ? 1 : 0) != 0);
        this.wasSorted = true;
        ArrayDeque<Object> startNodes = new ArrayDeque<Object>();
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<VertexT, Integer> entry : this.predecessorCounts.entrySet()) {
            if (entry.getValue() != 0) continue;
            startNodes.add(entry.getKey());
        }
        while (!startNodes.isEmpty()) {
            Object vertex = startNodes.remove();
            result.add(vertex);
            for (Object successor : this.adjacencyList.get(vertex)) {
                if (this.decrementAndGetCount(successor) != 0) continue;
                startNodes.add(successor);
            }
        }
        if (result.size() != this.predecessorCounts.size()) {
            throw new IllegalArgumentException("failed to perform topological sort, graph has a cycle");
        }
        return result;
    }

    private int decrementAndGetCount(VertexT vertex) {
        return this.predecessorCounts.compute(vertex, (__, count) -> {
            assert (count != null);
            return count - 1;
        });
    }
}

