/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import io.stargate.db.EventListener;
import java.util.List;

interface KeyspaceChangeListener
extends EventListener {
    @FormatMethod
    public void onKeyspaceChanged(String var1, @FormatString String var2, Object ... var3);

    default public void onDropKeyspace(String keyspaceName) {
        this.onKeyspaceChanged(keyspaceName, "it was dropped", new Object[0]);
    }

    default public void onCreateTable(String keyspaceName, String table) {
        this.onKeyspaceChanged(keyspaceName, "table %s was created", table);
    }

    default public void onCreateView(String keyspaceName, String view) {
        this.onKeyspaceChanged(keyspaceName, "view %s was created", view);
    }

    default public void onCreateType(String keyspaceName, String type) {
        this.onKeyspaceChanged(keyspaceName, "type %s was created", type);
    }

    default public void onCreateFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.onKeyspaceChanged(keyspaceName, "function %s was created", function);
    }

    default public void onCreateAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.onKeyspaceChanged(keyspaceName, "aggregate %s was created", aggregate);
    }

    default public void onAlterTable(String keyspaceName, String table) {
        this.onKeyspaceChanged(keyspaceName, "table %s was altered", table);
    }

    default public void onAlterView(String keyspaceName, String view) {
        this.onKeyspaceChanged(keyspaceName, "view %s was altered", view);
    }

    default public void onAlterType(String keyspaceName, String type) {
        this.onKeyspaceChanged(keyspaceName, "type %s was altered", type);
    }

    default public void onAlterFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.onKeyspaceChanged(keyspaceName, "function %s was altered", function);
    }

    default public void onAlterAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.onKeyspaceChanged(keyspaceName, "aggregate %s was altered", aggregate);
    }

    default public void onDropTable(String keyspaceName, String table) {
        this.onKeyspaceChanged(keyspaceName, "table %s was dropped", table);
    }

    default public void onDropView(String keyspaceName, String view) {
        this.onKeyspaceChanged(keyspaceName, "view %s was dropped", view);
    }

    default public void onDropType(String keyspaceName, String type) {
        this.onKeyspaceChanged(keyspaceName, "type %s was dropped", type);
    }

    default public void onDropFunction(String keyspaceName, String function, List<String> argumentTypes) {
        this.onKeyspaceChanged(keyspaceName, "function %s was dropped", function);
    }

    default public void onDropAggregate(String keyspaceName, String aggregate, List<String> argumentTypes) {
        this.onKeyspaceChanged(keyspaceName, "aggregate %s was dropped", aggregate);
    }
}

