/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyspaceDto {
    private static final Logger LOG = LoggerFactory.getLogger(KeyspaceDto.class);
    private final Keyspace keyspace;
    private final AuthorizationService authorizationService;
    private final AuthenticationSubject authenticationSubject;

    public KeyspaceDto(Keyspace keyspace, AuthorizationService authorizationService, AuthenticationSubject authenticationSubject) {
        this.keyspace = keyspace;
        this.authorizationService = authorizationService;
        this.authenticationSubject = authenticationSubject;
    }

    public String getName() {
        return this.keyspace.name();
    }

    public List<Map<String, String>> getDcs() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Map.Entry entries : this.keyspace.replication().entrySet()) {
            if (((String)entries.getKey()).equals("class") || ((String)entries.getKey()).equals("replication_factor")) continue;
            list.add((Map<String, String>)ImmutableMap.of((Object)"name", (Object)((String)entries.getKey()), (Object)"replicas", (Object)((String)entries.getValue())));
        }
        return list;
    }

    public List<Map<String, Object>> getTables() {
        return this.keyspace.tables().stream().filter(this::isAuthorized).map(KeyspaceDto::buildTable).collect(Collectors.toList());
    }

    public Map<String, Object> getTable(DataFetchingEnvironment environment) {
        String name = (String)environment.getArgument("name");
        Table table = this.keyspace.table(name);
        return table == null || !this.isAuthorized(table) ? null : KeyspaceDto.buildTable(table);
    }

    private boolean isAuthorized(Table table) {
        try {
            this.authorizationService.authorizeSchemaRead(this.authenticationSubject, Collections.singletonList(this.keyspace.name()), Collections.singletonList(table.name()), SourceAPI.GRAPHQL, ResourceKind.TABLE);
            return true;
        }
        catch (UnauthorizedException e) {
            LOG.debug("Not returning table {}.{} due to not being authorized", (Object)this.keyspace.name(), (Object)table.name());
            return false;
        }
    }

    public List<Map<String, Object>> getTypes() {
        return this.keyspace.userDefinedTypes().stream().map(KeyspaceDto::buildUdt).collect(Collectors.toList());
    }

    public Map<String, Object> getType(DataFetchingEnvironment environment) {
        String name = (String)environment.getArgument("name");
        UserDefinedType type = this.keyspace.userDefinedType(name);
        return type == null ? null : KeyspaceDto.buildUdt(type);
    }

    private static Map<String, Object> buildTable(Table table) {
        return ImmutableMap.of((Object)"name", (Object)table.name(), (Object)"columns", KeyspaceDto.buildColumns(table.columns(), true));
    }

    private static Map<String, Object> buildUdt(UserDefinedType type) {
        return ImmutableMap.of((Object)"name", (Object)type.name(), (Object)"fields", KeyspaceDto.buildColumns(type.columns(), false));
    }

    private static List<Map<String, Object>> buildColumns(List<Column> columns, boolean includeKind) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column column : columns) {
            list.add(KeyspaceDto.buildColumn(column, includeKind));
        }
        return list;
    }

    private static Map<String, Object> buildColumn(Column column, boolean includeKind) {
        return includeKind ? ImmutableMap.of((Object)"kind", (Object)KeyspaceDto.buildColumnKind(column), (Object)"name", (Object)column.name(), (Object)"type", KeyspaceDto.buildDataType(column.type())) : ImmutableMap.of((Object)"name", (Object)column.name(), (Object)"type", KeyspaceDto.buildDataType(column.type()));
    }

    private static Map<String, Object> buildDataType(Column.ColumnType columnType) {
        if (columnType.isUserDefined()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceDto.buildBasicType(columnType), (Object)"info", (Object)ImmutableMap.of((Object)"name", (Object)columnType.name(), (Object)"frozen", (Object)columnType.isFrozen()));
        }
        if (columnType.isCollection() || columnType.isTuple()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceDto.buildBasicType(columnType), (Object)"info", KeyspaceDto.buildParameterizedDataTypeInfo(columnType));
        }
        return ImmutableMap.of((Object)"basic", (Object)KeyspaceDto.buildBasicType(columnType));
    }

    private static Map<String, Object> buildParameterizedDataTypeInfo(Column.ColumnType columnType) {
        assert (columnType.isParameterized());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column.ColumnType type : columnType.parameters()) {
            list.add(KeyspaceDto.buildDataType(type));
        }
        return ImmutableMap.of((Object)"subTypes", list, (Object)"frozen", (Object)columnType.isFrozen());
    }

    private static String buildBasicType(Column.ColumnType columnType) {
        return columnType.rawType().name().toUpperCase();
    }

    private static String buildColumnKind(Column column) {
        switch (column.kind()) {
            case PartitionKey: {
                return "PARTITION";
            }
            case Clustering: {
                return "CLUSTERING";
            }
            case Regular: {
                return "REGULAR";
            }
            case Static: {
                return "STATIC";
            }
        }
        return "UNKNOWN";
    }
}

