/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.UUID;

public class UndeploySchemaFetcher
extends CassandraFetcher<Boolean> {
    @Override
    protected Boolean get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        String keyspaceName = (String)environment.getArgument("keyspace");
        Keyspace keyspace = context.getDataStore().schema().keyspace(keyspaceName);
        if (keyspace == null) {
            throw new IllegalArgumentException(String.format("Keyspace '%s' does not exist.", keyspaceName));
        }
        context.getAuthorizationService().authorizeSchemaWrite(context.getSubject(), keyspaceName, null, Scope.MODIFY, SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
        UUID expectedVersion = this.getExpectedVersion(environment);
        boolean force = (Boolean)environment.getArgument("force");
        new SchemaSourceDao(context.getDataStore()).undeploy(keyspaceName, expectedVersion, force);
        return true;
    }

    private UUID getExpectedVersion(DataFetchingEnvironment environment) {
        try {
            return UUID.fromString((String)environment.getArgument("expectedVersion"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid 'expectedVersion' value.");
        }
    }
}

