/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import graphql.Scalars;
import graphql.language.ListType;
import graphql.language.Type;
import graphql.schema.GraphQLScalarType;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundSelect;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.graphql.schema.scalars.CqlScalar;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class DeployedFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    protected final MappingModel mappingModel;

    public DeployedFetcher(MappingModel mappingModel) {
        this.mappingModel = mappingModel;
    }

    protected Object toCqlValue(Object graphqlValue, Column.ColumnType cqlType, Keyspace keyspace) {
        GraphQLScalarType graphqlScalar;
        Class expectedClass;
        if (graphqlValue == null) {
            return null;
        }
        if (cqlType.isParameterized()) {
            if (cqlType.rawType() == Column.Type.List) {
                return this.toCqlCollection(graphqlValue, cqlType, keyspace, ArrayList::new);
            }
            if (cqlType.rawType() == Column.Type.Set) {
                return this.toCqlCollection(graphqlValue, cqlType, keyspace, Sets::newLinkedHashSetWithExpectedSize);
            }
            throw new AssertionError((Object)String.format("Unsupported CQL type %s, this mapping should have failed at deployment time", cqlType));
        }
        if (cqlType.isUserDefined()) {
            return this.toCqlUdtValue(graphqlValue, cqlType, keyspace);
        }
        assert (cqlType instanceof Column.Type);
        Column.Type cqlScalarType = (Column.Type)cqlType;
        switch (cqlScalarType) {
            case Int: {
                expectedClass = Integer.class;
                graphqlScalar = Scalars.GraphQLInt;
                break;
            }
            case Boolean: {
                expectedClass = Boolean.class;
                graphqlScalar = Scalars.GraphQLBoolean;
                break;
            }
            case Double: {
                expectedClass = Double.class;
                graphqlScalar = Scalars.GraphQLFloat;
                break;
            }
            case Text: {
                expectedClass = String.class;
                graphqlScalar = Scalars.GraphQLString;
                break;
            }
            default: {
                CqlScalar cqlScalar = CqlScalar.fromCqlType(cqlScalarType).orElseThrow(() -> new IllegalArgumentException("Unsupported type " + cqlType));
                expectedClass = cqlScalar.getCqlValueClass();
                graphqlScalar = cqlScalar.getGraphqlType();
            }
        }
        return expectedClass.isInstance(graphqlValue) ? graphqlValue : graphqlScalar.getCoercing().parseValue(graphqlValue);
    }

    private Collection<Object> toCqlCollection(Object graphqlValue, Column.ColumnType cqlType, Keyspace keyspace, IntFunction<Collection<Object>> constructor) {
        Column.ColumnType elementType = (Column.ColumnType)cqlType.parameters().get(0);
        Collection graphqlCollection = (Collection)graphqlValue;
        return graphqlCollection.stream().map(element -> this.toCqlValue(element, elementType, keyspace)).collect(Collectors.toCollection(() -> (Collection)constructor.apply(graphqlCollection.size())));
    }

    private UdtValue toCqlUdtValue(Object graphqlValue, Column.ColumnType cqlType, Keyspace keyspace) {
        String udtName = cqlType.name();
        EntityModel udtModel = this.mappingModel.getEntities().get(udtName);
        if (udtModel == null) {
            throw new IllegalStateException(String.format("UDT '%s' is not mapped to a GraphQL type", udtName));
        }
        UserDefinedType udt = keyspace.userDefinedType(udtName);
        if (udt == null) {
            throw new IllegalStateException(String.format("Unknown UDT %s. It looks like it was dropped manually after the deployment.", udtName));
        }
        UdtValue udtValue = udt.create(new Object[0]);
        Map graphqlObject = (Map)graphqlValue;
        for (FieldModel field : udtModel.getRegularColumns()) {
            if (!graphqlObject.containsKey(field.getGraphqlName())) continue;
            Column.ColumnType fieldCqlType = udt.fieldType(field.getCqlName());
            if (fieldCqlType == null) {
                throw new IllegalStateException(String.format("Unknown field %s in UDT %s. It looks like it was altered manually after the deployment.", field.getCqlName(), udtName));
            }
            Object fieldGraphqlValue = graphqlObject.get(field.getGraphqlName());
            Object fieldCqlValue = this.toCqlValue(fieldGraphqlValue, fieldCqlType, keyspace);
            udtValue = (UdtValue)udtValue.set(field.getCqlName(), fieldCqlValue, fieldCqlType.codec());
        }
        return udtValue;
    }

    protected Object toGraphqlValue(Object cqlValue, Column.ColumnType cqlType, Type<?> graphqlType) {
        if (cqlValue == null) {
            return null;
        }
        if (cqlType.isParameterized()) {
            if (cqlType.rawType() == Column.Type.List) {
                return this.toGraphqlList(cqlValue, cqlType, graphqlType);
            }
            if (cqlType.rawType() == Column.Type.Set) {
                return this.toGraphqlList(cqlValue, cqlType, graphqlType);
            }
            throw new AssertionError((Object)String.format("Unsupported CQL type %s, this mapping should have failed at deployment time", cqlType));
        }
        if (cqlType.isUserDefined()) {
            return this.toGraphqlUdtValue((UdtValue)cqlValue);
        }
        if (cqlType == Column.Type.Uuid && TypeHelper.isGraphqlId(graphqlType)) {
            return cqlValue.toString();
        }
        return cqlValue;
    }

    private Object toGraphqlList(Object cqlValue, Column.ColumnType cqlType, Type<?> graphqlType) {
        Collection cqlCollection = (Collection)cqlValue;
        assert (graphqlType instanceof ListType);
        Type graphqlElementType = ((ListType)graphqlType).getType();
        Column.ColumnType cqlElementType = (Column.ColumnType)cqlType.parameters().get(0);
        return cqlCollection.stream().map(e -> this.toGraphqlValue(e, cqlElementType, graphqlElementType)).collect(Collectors.toList());
    }

    private Object toGraphqlUdtValue(UdtValue udtValue) {
        String udtName = udtValue.getType().getName().asInternal();
        EntityModel udtModel = this.mappingModel.getEntities().get(udtName);
        if (udtModel == null) {
            throw new IllegalStateException(String.format("UDT '%s' is not mapped to a GraphQL type", udtName));
        }
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)udtModel.getRegularColumns().size());
        for (FieldModel field : udtModel.getRegularColumns()) {
            Object cqlValue = udtValue.getObject(CqlIdentifier.fromInternal((String)field.getCqlName()));
            result.put(field.getGraphqlName(), this.toGraphqlValue(cqlValue, field.getCqlType(), field.getGraphqlType()));
        }
        return result;
    }

    protected ResultSet query(EntityModel entity, List<BuiltCondition> whereConditions, Optional<Integer> limit, Parameters parameters, StargateGraphqlContext context) throws UnauthorizedException {
        AbstractBound query = (AbstractBound)context.getDataStore().queryBuilder().select().column((String[])entity.getAllColumns().stream().map(FieldModel::getCqlName).toArray(String[]::new)).from(entity.getKeyspaceName(), entity.getCqlName()).where(whereConditions).limit((Integer)limit.orElse(null)).build().bind(new Object[0]);
        try {
            return context.getAuthorizationService().authorizedDataRead(() -> this.executeUnchecked(query, parameters, context), context.getSubject(), entity.getKeyspaceName(), entity.getCqlName(), TypedKeyValue.forSelect((BoundSelect)((BoundSelect)query)), SourceAPI.GRAPHQL);
        }
        catch (Exception e) {
            if (e instanceof UnauthorizedException) {
                throw (UnauthorizedException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> toSingleEntity(ResultSet resultSet, EntityModel entity) {
        return resultSet.hasNoMoreFetchedRows() ? null : this.toEntity(resultSet.one(), entity);
    }

    protected List<Map<String, Object>> toEntities(ResultSet resultSet, EntityModel entity) {
        return resultSet.currentPageRows().stream().map(row -> this.toEntity((Row)row, entity)).collect(Collectors.toList());
    }

    private Map<String, Object> toEntity(Row row, EntityModel entity) {
        HashMap<String, Object> singleResult = new HashMap<String, Object>();
        for (FieldModel field : entity.getAllColumns()) {
            Object cqlValue = row.getObject(field.getCqlName());
            singleResult.put(field.getGraphqlName(), this.toGraphqlValue(cqlValue, field.getCqlType(), field.getGraphqlType()));
        }
        return singleResult;
    }

    protected void copyRowToEntity(Row row, Map<String, Object> entityData, EntityModel entity) {
        for (FieldModel field : entity.getAllColumns()) {
            if (row.columns().stream().noneMatch(c -> c.name().equals(field.getCqlName()))) continue;
            Object cqlValue = row.getObject(field.getCqlName());
            entityData.put(field.getGraphqlName(), this.toGraphqlValue(cqlValue, field.getCqlType(), field.getGraphqlType()));
        }
    }

    protected ResultSet executeUnchecked(AbstractBound<?> query, Parameters parameters, StargateGraphqlContext context) {
        try {
            return (ResultSet)context.getDataStore().execute(query, __ -> parameters).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    protected List<BuiltCondition> bindWhere(List<ConditionModel> conditions, Predicate<String> hasArgument, Function<String, Object> getArgument, Function<List<ConditionModel>, Optional<String>> validator, Keyspace keyspace) {
        ArrayList<BuiltCondition> result = new ArrayList<BuiltCondition>();
        List<ConditionModel> activeConditions = this.bind(conditions, hasArgument, getArgument, keyspace, result);
        validator.apply(activeConditions).ifPresent(message -> {
            throw new IllegalArgumentException("Invalid arguments: " + message);
        });
        return result;
    }

    protected List<BuiltCondition> bindIf(List<ConditionModel> conditions, Predicate<String> hasArgument, Function<String, Object> getArgument, Keyspace keyspace) {
        ArrayList<BuiltCondition> result = new ArrayList<BuiltCondition>();
        this.bind(conditions, hasArgument, getArgument, keyspace, result);
        return result;
    }

    private <T extends ConditionModel> List<T> bind(List<T> conditions, Predicate<String> hasArgument, Function<String, Object> getArgument, Keyspace keyspace, List<BuiltCondition> result) {
        ArrayList<ConditionModel> activeConditions = new ArrayList<ConditionModel>();
        for (ConditionModel condition : conditions) {
            Column.ColumnType cqlType;
            FieldModel field = condition.getField();
            if (!hasArgument.test(condition.getArgumentName())) continue;
            activeConditions.add(condition);
            Object graphqlValue = getArgument.apply(condition.getArgumentName());
            switch (condition.getPredicate()) {
                case IN: {
                    cqlType = Column.Type.List.of(new Column.ColumnType[]{field.getCqlType()});
                    break;
                }
                case CONTAINS: {
                    cqlType = (Column.ColumnType)field.getCqlType().parameters().get(0);
                    break;
                }
                default: {
                    cqlType = field.getCqlType();
                }
            }
            Object cqlValue = this.toCqlValue(graphqlValue, cqlType, keyspace);
            result.add(condition.build(cqlValue));
        }
        return activeConditions;
    }
}

