/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.stargate.db.query.Predicate;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexTarget;
import java.util.Set;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public class CqlDirectives {
    private static final GraphQLEnumType ENTITY_TARGET_ENUM = GraphQLEnumType.newEnum().name("EntityTarget").description("The type of schema element a GraphQL object maps to").value(EntityModel.Target.TABLE.name()).value(EntityModel.Target.UDT.name()).build();
    public static final String ENTITY = "cql_entity";
    public static final String ENTITY_NAME = "name";
    public static final String ENTITY_TARGET = "target";
    private static final GraphQLDirective ENTITY_DIRECTIVE = GraphQLDirective.newDirective().name("cql_entity").description("Customizes the mapping of a GraphQL object to a CQL table or UDT").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).description("A custom table or UDT name (otherwise it uses the same name as the object)").build()).argument(GraphQLArgument.newArgument().name("target").type((GraphQLInputType)ENTITY_TARGET_ENUM).description("Whether the object maps to a CQL table (the default) or UDT").build()).validLocation(Introspection.DirectiveLocation.OBJECT).build();
    public static final String INPUT = "cql_input";
    public static final String INPUT_NAME = "name";
    private static final GraphQLDirective INPUT_DIRECTIVE = GraphQLDirective.newDirective().name("cql_input").description("Annotates a GraphQL object to trigger the generation of a matching input type.\nThe generated type will have the same fields (names and types), and can be referenced in mutations that target the corresponding CQL table or UDT.").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).description("The name of the generated type.\nIf not specified, it will be generated by appending 'Input' to the name of the original object").build()).validLocation(Introspection.DirectiveLocation.OBJECT).build();
    private static final GraphQLEnumType CLUSTERING_ORDER_ENUM = GraphQLEnumType.newEnum().name("ClusteringOrder").description("The sorting order for clustering columns").value("ASC").value("DESC").build();
    public static final String COLUMN = "cql_column";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_PARTITION_KEY = "partitionKey";
    public static final String COLUMN_CLUSTERING_ORDER = "clusteringOrder";
    public static final String COLUMN_TYPE_HINT = "typeHint";
    private static final GraphQLDirective COLUMN_DIRECTIVE = GraphQLDirective.newDirective().name("cql_column").description("Customizes the mapping of a GraphQL field to a CQL column (or UDT field)").argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).description("A custom column name (otherwise it uses the same name as the field)").build()).argument(GraphQLArgument.newArgument().name("partitionKey").type((GraphQLInputType)Scalars.GraphQLBoolean).description("Whether the column forms part of the partition key").build()).argument(GraphQLArgument.newArgument().name("clusteringOrder").type((GraphQLInputType)CLUSTERING_ORDER_ENUM).description("Whether the column is a clustering column, and if so in which order").build()).argument(GraphQLArgument.newArgument().name("typeHint").type((GraphQLInputType)Scalars.GraphQLString).description("The CQL type to map to (e.g. `frozen<list<varchar>>`).\nMost of the time you don't need this, the CQL type will be inferred from the GraphQL type. It is only needed for fine control over the \"frozen-ness\" of columns, or if you want to map a GraphQL list to a CQL set (instead of a list).").build()).validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).build();
    private static final GraphQLEnumType INDEX_TARGET_ENUM = GraphQLEnumType.newEnum().name("IndexTarget").description("Which part of a collection field will be indexed.").value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(IndexTarget.VALUES.name()).description("Indexes the values of a list field.\nThis is only allowed if the CQL type is not frozen.").build()).value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(IndexTarget.FULL.name()).description("Indexes the full collection for a list, set or map column.\nThis is only allowed if the CQL type is frozen.").build()).build();
    public static final String INDEX = "cql_index";
    public static final String INDEX_NAME = "name";
    public static final String INDEX_CLASS = "class";
    public static final String INDEX_TARGET = "target";
    public static final String INDEX_OPTIONS = "options";
    private static final GraphQLDirective INDEX_DIRECTIVE = GraphQLDirective.newDirective().name("cql_index").description(String.format("Requests the creation of a CQL index for a GraphQL object field.\nThis is only allowed for objects that map to CQL tables, and only for non-partition-key fields (in other words, fields that have neither`@%1$s.%2$s` nor `@%1$s.%3$s set).", "cql_column", "partitionKey", "clusteringOrder")).argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).description("A custom name for the index. If not specified, one will be generated.").build()).argument(GraphQLArgument.newArgument().name("class").type((GraphQLInputType)Scalars.GraphQLString).description("If the index is custom, the name of the index class to use. If not specified, this will be a regular secondary index.").build()).argument(GraphQLArgument.newArgument().name("target").type((GraphQLInputType)INDEX_TARGET_ENUM).description("(Only used with list fields) Which part of the field to index. If not specified, this will default to `VALUES`.").build()).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)Scalars.GraphQLString).description("Any custom options to pass to the index, in the format: `'option1': 'value1', 'option2': 'value2'...`").build()).validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).build();
    public static final String PAGING_STATE = "cql_pagingState";
    private static final GraphQLDirective PAGING_STATE_DIRECTIVE = GraphQLDirective.newDirective().name("cql_pagingState").description("Annotates a query parameter to indicate that it will receive the paging state. That parameter must have type `String`.").validLocation(Introspection.DirectiveLocation.ARGUMENT_DEFINITION).build();
    public static final String PAYLOAD = "cql_payload";
    private static final GraphQLDirective PAYLOAD_DIRECTIVE = GraphQLDirective.newDirective().name("cql_payload").description("Indicates that a type represents a \"payload\" object that will be used as the argument or return type of a GraphQL operation. Such objects  are NOT mapped to a CQL table.").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INPUT_OBJECT}).build();
    private static final GraphQLEnumType QUERY_CONSISTENCY_ENUM = GraphQLEnumType.newEnum().name("QueryConsistency").description("The consistency level of the CQL SELECT generated for a query.").value(ConsistencyLevel.LOCAL_ONE.name()).value(ConsistencyLevel.LOCAL_QUORUM.name()).value(ConsistencyLevel.ALL.name()).value(ConsistencyLevel.SERIAL.name()).value(ConsistencyLevel.LOCAL_SERIAL.name()).build();
    public static final String SELECT = "cql_select";
    public static final String SELECT_LIMIT = "limit";
    public static final String SELECT_PAGE_SIZE = "pageSize";
    public static final String SELECT_CONSISTENCY_LEVEL = "consistencyLevel";
    private static final GraphQLDirective SELECT_DIRECTIVE = GraphQLDirective.newDirective().name("cql_select").description("Provides additional options to the CQL SELECT generated for a query.\nThis is only required if you pass arguments to the directive. Otherwise, GraphQL queries are always mapped to SELECT implicitly.").argument(GraphQLArgument.newArgument().name("limit").type((GraphQLInputType)Scalars.GraphQLInt).description("How many results to return overall.").build()).argument(GraphQLArgument.newArgument().name("pageSize").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)100).description("How many results to return at a time.\nIf there are more, paging can be implemented by:\n\n" + String.format("* wrapping the return type into an object annotated with @%s, that defines a field `pagingState: String`;\n", "cql_payload") + String.format("* adding a `String` parameter annotated with `@%s` to the query.\n", "cql_pagingState") + "\nThen the page state returned by each query can be reinjected into the next query to get the next page.").build()).argument(GraphQLArgument.newArgument().name("consistencyLevel").type((GraphQLInputType)QUERY_CONSISTENCY_ENUM).description("The consistency level to use.").defaultValue((Object)ConsistencyLevel.LOCAL_QUORUM.name()).build()).validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).build();
    private static final GraphQLEnumType MUTATION_CONSISTENCY_ENUM = GraphQLEnumType.newEnum().name("MutationConsistency").description("The consistency level of the CQL query generated for a mutation.").value(ConsistencyLevel.LOCAL_ONE.name()).value(ConsistencyLevel.LOCAL_QUORUM.name()).value(ConsistencyLevel.ALL.name()).build();
    private static final GraphQLEnumType SERIAL_CONSISTENCY_ENUM = GraphQLEnumType.newEnum().name("SerialConsistency").description("The serial consistency level of the CQL query generated for a mutation.").value(ConsistencyLevel.SERIAL.name()).value(ConsistencyLevel.LOCAL_SERIAL.name()).build();
    public static final String INSERT = "cql_insert";
    public static final String INSERT_IF_NOT_EXISTS = "ifNotExists";
    public static final String UPDATE = "cql_update";
    public static final String UPDATE_OR_DELETE_TARGET_ENTITY = "targetEntity";
    public static final String UPDATE_OR_DELETE_IF_EXISTS = "ifExists";
    public static final String DELETE = "cql_delete";
    public static final String MUTATION_CONSISTENCY_LEVEL = "consistencyLevel";
    public static final String MUTATION_SERIAL_CONSISTENCY_LEVEL = "serialConsistency";
    public static final String UPDATE_OR_INSERT_TTL = "ttl";
    private static final GraphQLArgument MUTATION_CONSISTENCY_LEVEL_ARGUMENT = GraphQLArgument.newArgument().name("consistencyLevel").type((GraphQLInputType)MUTATION_CONSISTENCY_ENUM).description("The consistency level to use.").defaultValue((Object)ConsistencyLevel.LOCAL_QUORUM.name()).build();
    private static final GraphQLArgument MUTATION_SERIAL_CONSISTENCY_LEVEL_ARGUMENT = GraphQLArgument.newArgument().name("serialConsistency").type((GraphQLInputType)SERIAL_CONSISTENCY_ENUM).description("The serial consistency level to use.").defaultValue((Object)ConsistencyLevel.SERIAL.name()).build();
    private static final GraphQLArgument UPDATE_OR_INSERT_TTL_ARGUMENT = GraphQLArgument.newArgument().name("ttl").type((GraphQLInputType)Scalars.GraphQLString).description("The TTL to use.\nIf this is a raw integer, it will be interpreted as a number of seconds. Otherwise, it must be a valid ISO-8601 duration string (note that the minimum granularity is seconds, so if the duration has a nanosecond part it will be truncated). The value must be between 0 and 2^31- 1 (both included).").build();
    private static final GraphQLDirective INSERT_DIRECTIVE = GraphQLDirective.newDirective().name("cql_insert").description("Indicates that a mutation should be mapped to a CQL INSERT query.\nNote that this is not required if the mutation name starts with `insert` or `create`.").argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).description("What to do if the entity already exists.\n\n* If `false`, the insert will overwrite any data that was already present.\n* If `true`, it won't, and the mutation will return the existing entity. In this case, it is strongly recommended to wrap the response in a payload object that also defines an `applied` field, for example: `type InsertUserResponse @cql_payload { applied: Boolean!, user: User! }`\n\nNote that setting this flag to `true` might increase the latency of the operation. It should not be used casually.\nBy convention, this flag will be set automatically if the mutation name ends with `IfNotExists`.").build()).argument(MUTATION_CONSISTENCY_LEVEL_ARGUMENT).argument(MUTATION_SERIAL_CONSISTENCY_LEVEL_ARGUMENT).argument(UPDATE_OR_INSERT_TTL_ARGUMENT).validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).build();
    private static final GraphQLDirective UPDATE_DIRECTIVE = GraphQLDirective.newDirective().name("cql_update").description("Indicates that a mutation should be mapped to a CQL UPDATE query.\nNote that this is not required if the mutation name starts with `update`.").argument(GraphQLArgument.newArgument().name("targetEntity").type((GraphQLInputType)Scalars.GraphQLString).description("The name of the type to update.\nThis is only needed if the mutation takes individual key fields as arguments (as opposed to an instance of the type).\nThis must be a type that maps to a table.").build()).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).description("Whether to check if the entity exists before updating.\n\nUpdate mutations return the outcome of the update, either directly if the mutation returns `Boolean`, or via the `applied` field if the mutation returns a response payload object.\n\n* If `ifExists` is `false`, the mutation will always return `true`, whether it actually updated something or not.\n* If `ifExists` is `true`, the mutation will return `true` if it updated something, and `false`otherwise.\n\nNote that setting this flag to `true` might increase the latency of the operation. It should not be used casually.\nBy convention, this flag will be set automatically if the mutation name ends with `IfExists`.").build()).argument(MUTATION_CONSISTENCY_LEVEL_ARGUMENT).argument(MUTATION_SERIAL_CONSISTENCY_LEVEL_ARGUMENT).argument(UPDATE_OR_INSERT_TTL_ARGUMENT).validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).build();
    private static final GraphQLDirective DELETE_DIRECTIVE = GraphQLDirective.newDirective().name("cql_delete").description("Indicates that a mutation should be mapped to a CQL DELETE query.\nNote that this is not required if the mutation name starts with `delete` or `remove`.").argument(GraphQLArgument.newArgument().name("targetEntity").type((GraphQLInputType)Scalars.GraphQLString).description("The name of the type to delete.\nThis is only needed if the mutation takes individual key fields as arguments (as opposed to an instance of the type).\nThis must be a type that maps to a table.").build()).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).description("Whether to check if the entity exists before deleting.\n\nDelete mutations return the outcome of the deletion, either directly if the mutation returns `Boolean`, or via the `applied` field if the mutation returns a response payload object.\n\n* If `ifExists` is `false`, the mutation will always return `true`, whether it actually deleted something or not.\n* If `ifExists` is `true`, the mutation will return `true` if it deleted something, and `false` otherwise.\n\nNote that setting this flag to `true` might increase the latency of the operation. It should not be used casually.\nBy convention, this flag will be set automatically if the mutation name ends with `IfExists`.").build()).argument(MUTATION_CONSISTENCY_LEVEL_ARGUMENT).argument(MUTATION_SERIAL_CONSISTENCY_LEVEL_ARGUMENT).validLocation(Introspection.DirectiveLocation.FIELD_DEFINITION).build();
    public static final String WHERE = "cql_where";
    public static final String IF = "cql_if";
    public static final String INCREMENT = "cql_increment";
    public static final String WHERE_OR_IF_OR_INCREMENT_FIELD = "field";
    public static final String WHERE_OR_IF_PREDICATE = "predicate";
    public static final String INCREMENT_PREPEND = "prepend";
    public static final String TIMESTAMP = "cql_timestamp";
    private static final GraphQLEnumType PREDICATE_ENUM = GraphQLEnumType.newEnum().name("Predicate").description(String.format("A predicate used in `@%s` to define a condition.", "cql_where")).value(Predicate.EQ.name()).value(Predicate.IN.name()).value(Predicate.LT.name()).value(Predicate.GT.name()).value(Predicate.LTE.name()).value(Predicate.GTE.name()).value(Predicate.CONTAINS.name()).build();
    private static final GraphQLDirective WHERE_DIRECTIVE = GraphQLDirective.newDirective().name("cql_where").description("Annotates a parameter to customize the WHERE condition that is generated from it.").argument(GraphQLArgument.newArgument().name("field").type((GraphQLInputType)Scalars.GraphQLString).description("The name of the field that the condition applies to (if absent, it will be the name of the argument).").build()).argument(GraphQLArgument.newArgument().name("predicate").type((GraphQLInputType)PREDICATE_ENUM).defaultValue((Object)Predicate.EQ.name()).description("The predicate to use for the condition.").build()).validLocation(Introspection.DirectiveLocation.ARGUMENT_DEFINITION).build();
    private static final GraphQLDirective INCREMENT_DIRECTIVE = GraphQLDirective.newDirective().name("cql_increment").description("Annotates a parameter to indicate that it will be incremented.\nIt is supported on the counter, set and list types.\nThis is only allowed for update mutations.").argument(GraphQLArgument.newArgument().name("field").type((GraphQLInputType)Scalars.GraphQLString).description("The name of the field that the increment applies to (if absent, it will be the name of the argument).").build()).argument(GraphQLArgument.newArgument().name("prepend").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).description("Specifies whether the value should be appended or prepended.\nIt applies only to list. The default is false, meaning that the value will be appended.").build()).validLocation(Introspection.DirectiveLocation.ARGUMENT_DEFINITION).build();
    private static final GraphQLEnumType IF_PREDICATE_ENUM = GraphQLEnumType.newEnum().name("IfPredicate").description(String.format("A predicate used in `@%s` to define a condition.", "cql_if")).value(Predicate.EQ.name()).value(Predicate.NEQ.name()).value(Predicate.IN.name()).value(Predicate.LT.name()).value(Predicate.GT.name()).value(Predicate.LTE.name()).value(Predicate.GTE.name()).build();
    private static final GraphQLDirective IF_DIRECTIVE = GraphQLDirective.newDirective().name("cql_if").description("Annotates a parameter to indicate that it will be used as a condition that must test true on the selected entity in order for the mutation to be applied.\n\nThis is only allowed for delete and update mutations.").argument(GraphQLArgument.newArgument().name("field").type((GraphQLInputType)Scalars.GraphQLString).description("The name of the field that the condition applies to (if absent, it will be the name of the argument).").build()).argument(GraphQLArgument.newArgument().name("predicate").type((GraphQLInputType)IF_PREDICATE_ENUM).defaultValue((Object)Predicate.EQ.name()).description("The predicate to use for the condition.").build()).validLocation(Introspection.DirectiveLocation.ARGUMENT_DEFINITION).build();
    private static final GraphQLDirective TIMESTAMP_DIRECTIVE = GraphQLDirective.newDirective().name("cql_timestamp").description("Annotates a parameter to indicate that it will be used as a write timestamp for this row.This is only allowed for insert and update mutations. The parameter can be either a `BigInt` (that represents a number of microseconds since the epoch), or a `String` (that represents an ISO-8601 zoned date time, e.g. `2007-12-03T10:15:30+01:00`).").validLocation(Introspection.DirectiveLocation.ARGUMENT_DEFINITION).build();
    public static final String ALL_AS_STRING;
    public static final TypeDefinitionRegistry ALL_AS_REGISTRY;

    private static /* synthetic */ boolean lambda$static$0(Set defaultDirectives, String d) {
        return !defaultDirectives.contains(d);
    }

    static {
        GraphQLObjectType dummyQueryType = GraphQLObjectType.newObject().name("Query").field(GraphQLFieldDefinition.newFieldDefinition().name("dummy").type((GraphQLOutputType)Scalars.GraphQLBoolean).build()).build();
        GraphQLSchema schema = GraphQLSchema.newSchema().additionalDirective(ENTITY_DIRECTIVE).additionalDirective(INPUT_DIRECTIVE).additionalDirective(COLUMN_DIRECTIVE).additionalDirective(INDEX_DIRECTIVE).additionalDirective(PAGING_STATE_DIRECTIVE).additionalDirective(PAYLOAD_DIRECTIVE).additionalDirective(SELECT_DIRECTIVE).additionalDirective(INSERT_DIRECTIVE).additionalDirective(UPDATE_DIRECTIVE).additionalDirective(DELETE_DIRECTIVE).additionalDirective(WHERE_DIRECTIVE).additionalDirective(IF_DIRECTIVE).additionalDirective(INCREMENT_DIRECTIVE).additionalDirective(TIMESTAMP_DIRECTIVE).query(dummyQueryType).build();
        ImmutableSet defaultDirectives = ImmutableSet.of((Object)"include", (Object)"skip", (Object)"deprecated", (Object)"specifiedBy");
        ALL_AS_STRING = new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeDirectives(arg_0 -> CqlDirectives.lambda$static$0((Set)defaultDirectives, arg_0)).includeSchemaElement(e -> e != dummyQueryType)).print(schema);
        ALL_AS_REGISTRY = new SchemaParser().parse(ALL_AS_STRING);
    }
}

