/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.Type;
import io.stargate.db.schema.Column;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexModel;
import java.util.Optional;

public class FieldModel {
    private final String graphqlName;
    private final Type<?> graphqlType;
    private final String cqlName;
    private final Column.ColumnType cqlType;
    private final boolean partitionKey;
    private final Optional<Column.Order> clusteringOrder;
    private final Optional<IndexModel> index;

    FieldModel(String graphqlName, Type<?> graphqlType, String cqlName, Column.ColumnType cqlType, boolean partitionKey, Optional<Column.Order> clusteringOrder, Optional<IndexModel> index) {
        this.graphqlName = graphqlName;
        this.graphqlType = graphqlType;
        this.cqlName = cqlName;
        this.cqlType = cqlType;
        this.partitionKey = partitionKey;
        this.clusteringOrder = clusteringOrder;
        this.index = index;
    }

    public String getGraphqlName() {
        return this.graphqlName;
    }

    public Type<?> getGraphqlType() {
        return this.graphqlType;
    }

    public String getCqlName() {
        return this.cqlName;
    }

    public Column.ColumnType getCqlType() {
        return this.cqlType;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public FieldModel asPartitionKey() {
        return new FieldModel(this.graphqlName, this.graphqlType, this.cqlName, this.cqlType, true, this.clusteringOrder, this.index);
    }

    public Optional<Column.Order> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public boolean isClusteringColumn() {
        return this.getClusteringOrder().isPresent();
    }

    public boolean isPrimaryKey() {
        return this.partitionKey || this.clusteringOrder.isPresent();
    }

    public Optional<IndexModel> getIndex() {
        return this.index;
    }
}

