/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum IndexTarget {
    KEYS((CollectionIndexingType)ImmutableCollectionIndexingType.builder().indexKeys(true).build()),
    VALUES((CollectionIndexingType)ImmutableCollectionIndexingType.builder().indexValues(true).build()),
    ENTRIES((CollectionIndexingType)ImmutableCollectionIndexingType.builder().indexEntries(true).build()),
    FULL((CollectionIndexingType)ImmutableCollectionIndexingType.builder().indexFull(true).build());

    private static final Map<CollectionIndexingType, IndexTarget> BY_TYPE;
    private final CollectionIndexingType indexingType;

    private IndexTarget(CollectionIndexingType indexingType) {
        this.indexingType = indexingType;
    }

    public CollectionIndexingType toIndexingType() {
        return this.indexingType;
    }

    public static IndexTarget fromIndexingType(CollectionIndexingType indexingType) {
        IndexTarget value = BY_TYPE.get(indexingType);
        if (value == null) {
            throw new IllegalArgumentException("Invalid value " + indexingType);
        }
        return value;
    }

    static {
        BY_TYPE = Arrays.stream(IndexTarget.values()).collect(Collectors.toMap(IndexTarget::toIndexingType, Function.identity()));
    }
}

