/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import io.stargate.graphql.schema.graphqlfirst.processor.ArgumentDirectiveModels;
import io.stargate.graphql.schema.graphqlfirst.processor.ArgumentDirectiveModelsBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.QueryModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

class QueryModelBuilder
extends OperationModelBuilderBase<QueryModel> {
    private final String parentTypeName;

    QueryModelBuilder(FieldDefinition query, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(query, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    QueryModel build() throws SkipException {
        Optional<Directive> cqlSelectDirective = DirectiveHelper.getDirective("cql_select", this.operation);
        Optional<Integer> limit = cqlSelectDirective.flatMap(d -> DirectiveHelper.getIntArgument(d, "limit", this.context));
        Optional<Integer> pageSize = cqlSelectDirective.flatMap(d -> DirectiveHelper.getIntArgument(d, "pageSize", this.context));
        Optional<ConsistencyLevel> consistencyLevel = cqlSelectDirective.flatMap(d -> DirectiveHelper.getEnumArgument(d, "consistencyLevel", ConsistencyLevel.class, this.context));
        OperationModel.ReturnType returnType = this.getReturnType("Query " + this.operationName);
        EntityModel entity = returnType.getEntity().filter(e -> e.getTarget() == EntityModel.Target.TABLE).orElseThrow(() -> {
            this.invalidMapping("Query %s: return type must reference an entity that maps to a table", this.operationName);
            return SkipException.INSTANCE;
        });
        Optional<String> pagingStateArgumentName = this.findFieldNameWithDirective("cql_pagingState", Scalars.GraphQLString);
        ArgumentDirectiveModels conditions = new ArgumentDirectiveModelsBuilder(this.operation, ArgumentDirectiveModelsBuilder.OperationType.SELECT, entity, this.entities, this.context).build();
        List<ConditionModel> whereConditions = conditions.getWhereConditions();
        this.validateNoFiltering(whereConditions, entity);
        return new QueryModel(this.parentTypeName, this.operation, entity, whereConditions, pagingStateArgumentName, limit, pageSize, consistencyLevel, returnType);
    }
}

