/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.db.query.Predicate;
import io.stargate.graphql.schema.graphqlfirst.processor.ArgumentDirectiveModels;
import io.stargate.graphql.schema.graphqlfirst.processor.ArgumentDirectiveModelsBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.IncrementModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.processor.UpdateModel;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class UpdateModelBuilder
extends MutationModelBuilder {
    private final String parentTypeName;

    UpdateModelBuilder(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(mutation, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    MutationModel build() throws SkipException {
        List<IncrementModel> incrementModels;
        List<ConditionModel> ifConditions;
        List<ConditionModel> whereConditions;
        EntityModel entity;
        List arguments;
        Set unsupportedFields;
        Optional<Directive> cqlUpdateDirective = DirectiveHelper.getDirective("cql_update", this.operation);
        boolean ifExists = this.computeIfExists(cqlUpdateDirective);
        OperationModel.ReturnType returnType = this.getReturnType("Mutation " + this.operationName);
        if (returnType != OperationModel.SimpleReturnType.BOOLEAN && !(returnType instanceof ResponsePayloadModel)) {
            this.invalidMapping("Mutation %s: invalid return type. Expected Boolean or a response payload", this.operationName);
            throw SkipException.INSTANCE;
        }
        ResponsePayloadModel payload = null;
        if (returnType instanceof ResponsePayloadModel && !(unsupportedFields = (Set)(payload = (ResponsePayloadModel)returnType).getTechnicalFields().stream().filter(f -> f != ResponsePayloadModel.TechnicalField.APPLIED).map(ResponsePayloadModel.TechnicalField::getGraphqlName).collect(Collectors.toCollection(HashSet::new))).isEmpty()) {
            this.warn("Mutation %s: 'applied' is the only supported field in update response payloads. Others will always be null (%s).", this.operationName, String.join((CharSequence)", ", unsupportedFields));
        }
        if ((arguments = this.operation.getInputValueDefinitions()).isEmpty()) {
            this.invalidMapping("Mutation %s: updates must take either the entity input type or a list of primary key fields", this.operationName);
            throw SkipException.INSTANCE;
        }
        InputValueDefinition firstArgument = (InputValueDefinition)arguments.get(0);
        Optional<EntityModel> entityFromFirstArgument = this.findEntity(firstArgument);
        Optional<String> entityArgumentName = entityFromFirstArgument.map(__ -> firstArgument.getName());
        if (entityFromFirstArgument.isPresent()) {
            if (arguments.size() > 1) {
                this.invalidMapping("Mutation %s: if an update takes an entity input type, it must be the only argument", this.operationName);
                throw SkipException.INSTANCE;
            }
            entity = entityFromFirstArgument.get();
            whereConditions = entity.getPrimaryKeyWhereConditions();
            ifConditions = Collections.emptyList();
            incrementModels = Collections.emptyList();
        } else {
            entity = this.entityFromDirective(cqlUpdateDirective, "update", "cql_update");
            ArgumentDirectiveModels directives = new ArgumentDirectiveModelsBuilder(this.operation, ArgumentDirectiveModelsBuilder.OperationType.UPDATE, entity, this.entities, this.context).build();
            whereConditions = directives.getWhereConditions();
            ifConditions = directives.getIfConditions();
            this.validate(whereConditions, ifConditions, ifExists, entity);
            incrementModels = directives.getIncrementModels();
        }
        Optional<String> cqlTimestampArgumentName = this.findFieldNameWithDirective("cql_timestamp", Scalars.GraphQLString, CqlScalar.BIGINT.getGraphqlType());
        return new UpdateModel(this.parentTypeName, this.operation, entity, whereConditions, ifConditions, entityArgumentName, returnType, Optional.ofNullable(payload), ifExists, incrementModels, this.getConsistencyLevel(cqlUpdateDirective), this.getSerialConsistencyLevel(cqlUpdateDirective), this.getTtl(cqlUpdateDirective), cqlTimestampArgumentName);
    }

    private void validate(List<ConditionModel> whereConditions, List<ConditionModel> ifConditions, boolean ifExists, EntityModel entity) throws SkipException {
        Optional<String> maybeError = entity.validateForUpdate(whereConditions);
        if (maybeError.isPresent()) {
            this.invalidMapping("Operation %s: %s", this.operationName, maybeError.get());
            throw SkipException.INSTANCE;
        }
        if (!ifConditions.isEmpty()) {
            this.ensureNoInConditions(whereConditions);
            if (ifExists) {
                this.invalidMapping("Operation %s: can't use @%s and %s at the same time", this.operationName, "cql_if", "ifExists");
                throw SkipException.INSTANCE;
            }
        }
    }

    private void ensureNoInConditions(List<ConditionModel> whereConditions) throws SkipException {
        for (ConditionModel whereCondition : whereConditions) {
            if (whereCondition.getPredicate() != Predicate.IN) continue;
            this.invalidMapping("Operation %s: IN predicates on primary key fields are not allowed if there are @%s conditions (%s)", this.operationName, "cql_if", whereCondition.getArgumentName());
            throw SkipException.INSTANCE;
        }
    }
}

