/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.bridge.grpc;

import io.stargate.bridge.proto.QueryOuterClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TypeSpecs {
    public static final QueryOuterClass.TypeSpec ASCII = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.ASCII);
    public static final QueryOuterClass.TypeSpec BIGINT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.BIGINT);
    public static final QueryOuterClass.TypeSpec BLOB = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.BLOB);
    public static final QueryOuterClass.TypeSpec BOOLEAN = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.BOOLEAN);
    public static final QueryOuterClass.TypeSpec COUNTER = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.COUNTER);
    public static final QueryOuterClass.TypeSpec DECIMAL = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.DECIMAL);
    public static final QueryOuterClass.TypeSpec DOUBLE = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.DOUBLE);
    public static final QueryOuterClass.TypeSpec FLOAT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.FLOAT);
    public static final QueryOuterClass.TypeSpec INT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.INT);
    public static final QueryOuterClass.TypeSpec TIMESTAMP = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.TIMESTAMP);
    public static final QueryOuterClass.TypeSpec UUID = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.UUID);
    public static final QueryOuterClass.TypeSpec VARCHAR = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.VARCHAR);
    public static final QueryOuterClass.TypeSpec VARINT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.VARINT);
    public static final QueryOuterClass.TypeSpec TIMEUUID = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.TIMEUUID);
    public static final QueryOuterClass.TypeSpec INET = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.INET);
    public static final QueryOuterClass.TypeSpec DATE = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.DATE);
    public static final QueryOuterClass.TypeSpec TIME = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.TIME);
    public static final QueryOuterClass.TypeSpec SMALLINT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.SMALLINT);
    public static final QueryOuterClass.TypeSpec TINYINT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.TINYINT);
    public static final QueryOuterClass.TypeSpec DURATION = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.DURATION);
    public static final QueryOuterClass.TypeSpec LINESTRING = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.LINESTRING);
    public static final QueryOuterClass.TypeSpec POINT = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.POINT);
    public static final QueryOuterClass.TypeSpec POLYGON = TypeSpecs.buildFromBasic(QueryOuterClass.TypeSpec.Basic.POLYGON);

    public static QueryOuterClass.TypeSpec list(QueryOuterClass.TypeSpec element) {
        return QueryOuterClass.TypeSpec.newBuilder().setList(QueryOuterClass.TypeSpec.List.newBuilder().setElement(element)).build();
    }

    public static QueryOuterClass.TypeSpec frozenList(QueryOuterClass.TypeSpec element) {
        return QueryOuterClass.TypeSpec.newBuilder().setList(QueryOuterClass.TypeSpec.List.newBuilder().setElement(element).setFrozen(true)).build();
    }

    public static QueryOuterClass.TypeSpec set(QueryOuterClass.TypeSpec element) {
        return QueryOuterClass.TypeSpec.newBuilder().setSet(QueryOuterClass.TypeSpec.Set.newBuilder().setElement(element)).build();
    }

    public static QueryOuterClass.TypeSpec frozenSet(QueryOuterClass.TypeSpec element) {
        return QueryOuterClass.TypeSpec.newBuilder().setSet(QueryOuterClass.TypeSpec.Set.newBuilder().setElement(element).setFrozen(true)).build();
    }

    public static QueryOuterClass.TypeSpec map(QueryOuterClass.TypeSpec key, QueryOuterClass.TypeSpec value) {
        return QueryOuterClass.TypeSpec.newBuilder().setMap(QueryOuterClass.TypeSpec.Map.newBuilder().setKey(key).setValue(value)).build();
    }

    public static QueryOuterClass.TypeSpec frozenMap(QueryOuterClass.TypeSpec key, QueryOuterClass.TypeSpec value) {
        return QueryOuterClass.TypeSpec.newBuilder().setMap(QueryOuterClass.TypeSpec.Map.newBuilder().setKey(key).setValue(value).setFrozen(true)).build();
    }

    public static QueryOuterClass.TypeSpec udt(String name, Map<String, QueryOuterClass.TypeSpec> fields) {
        return QueryOuterClass.TypeSpec.newBuilder().setUdt(QueryOuterClass.TypeSpec.Udt.newBuilder().setName(name).putAllFields(fields)).build();
    }

    public static QueryOuterClass.TypeSpec frozenUdt(String name, Map<String, QueryOuterClass.TypeSpec> fields) {
        return QueryOuterClass.TypeSpec.newBuilder().setUdt(QueryOuterClass.TypeSpec.Udt.newBuilder().setName(name).putAllFields(fields).setFrozen(true)).build();
    }

    public static QueryOuterClass.TypeSpec tuple(QueryOuterClass.TypeSpec ... elements) {
        QueryOuterClass.TypeSpec.Tuple.Builder builder = QueryOuterClass.TypeSpec.Tuple.newBuilder();
        for (QueryOuterClass.TypeSpec element : elements) {
            builder.addElements(element);
        }
        return QueryOuterClass.TypeSpec.newBuilder().setTuple(builder).build();
    }

    public static boolean isCollection(QueryOuterClass.TypeSpec type) {
        switch (type.getSpecCase()) {
            case LIST: 
            case SET: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public static String format(QueryOuterClass.TypeSpec type) {
        switch (type.getSpecCase()) {
            case BASIC: {
                return TypeSpecs.formatBasic(type.getBasic());
            }
            case MAP: {
                QueryOuterClass.TypeSpec.Map map = type.getMap();
                return String.format(map.getFrozen() ? "frozen<map<%s,%s>>" : "map<%s,%s>", TypeSpecs.format(map.getKey()), TypeSpecs.format(map.getValue()));
            }
            case LIST: {
                QueryOuterClass.TypeSpec.List list = type.getList();
                return String.format(list.getFrozen() ? "frozen<list<%s>>" : "list<%s>", TypeSpecs.format(list.getElement()));
            }
            case SET: {
                QueryOuterClass.TypeSpec.Set set = type.getSet();
                return String.format(set.getFrozen() ? "frozen<set<%s>>" : "set<%s>", TypeSpecs.format(set.getElement()));
            }
            case UDT: {
                QueryOuterClass.TypeSpec.Udt udt = type.getUdt();
                return String.format(udt.getFrozen() ? "frozen<\"%s\">" : "\"%s\"", udt.getName());
            }
            case TUPLE: {
                QueryOuterClass.TypeSpec.Tuple tuple = type.getTuple();
                return tuple.getElementsList().stream().map(TypeSpecs::format).collect(Collectors.joining(",", "tuple<", ">"));
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type.getSpecCase());
    }

    private static String formatBasic(QueryOuterClass.TypeSpec.Basic basic) {
        switch (basic) {
            case VARCHAR: {
                return "text";
            }
            case POINT: {
                return "'PointType'";
            }
            case LINESTRING: {
                return "'LineStringType'";
            }
            case POLYGON: {
                return "'PolygonType'";
            }
        }
        return basic.name().toLowerCase();
    }

    public static QueryOuterClass.TypeSpec parse(String typeString, Collection<QueryOuterClass.TypeSpec.Udt> udts, boolean strict) {
        if ((typeString = typeString.trim()).isEmpty()) {
            throw new IllegalArgumentException("Invalid empty type name");
        }
        switch (typeString) {
            case "'LineStringType'": {
                return LINESTRING;
            }
            case "'PointType'": {
                return POINT;
            }
            case "'PolygonType'": {
                return POLYGON;
            }
        }
        if (typeString.charAt(0) == '\'') {
            throw new IllegalArgumentException("Custom types are not supported");
        }
        int lastCharIdx = typeString.length() - 1;
        if (typeString.charAt(0) == '\"') {
            if (typeString.charAt(lastCharIdx) != '\"' || typeString.length() < 3) {
                throw new IllegalArgumentException("Malformed type name (missing closing quote): " + typeString);
            }
            String udtName = typeString.substring(1, lastCharIdx).replaceAll("\"\"", "\"");
            return TypeSpecs.findUdt(udtName, udts, strict);
        }
        int paramsIdx = typeString.indexOf(60);
        if (paramsIdx < 0) {
            return TypeSpecs.parseBasicOrUdt(typeString, udts, strict);
        }
        String baseTypeName = typeString.substring(0, paramsIdx).trim();
        if (typeString.charAt(lastCharIdx) != '>') {
            throw new IllegalArgumentException(String.format("Malformed type name: parameters for type %s are missing a closing '>'", baseTypeName));
        }
        String paramsString = typeString.substring(paramsIdx + 1, lastCharIdx);
        List<QueryOuterClass.TypeSpec> parameters = TypeSpecs.splitAndParseParameters(typeString, paramsString, udts, strict);
        if ("frozen".equalsIgnoreCase(baseTypeName)) {
            TypeSpecs.checkParameterCount(parameters, 1, "frozen");
            return TypeSpecs.freeze(parameters.get(0));
        }
        if ("list".equalsIgnoreCase(baseTypeName)) {
            TypeSpecs.checkParameterCount(parameters, 1, "list");
            return QueryOuterClass.TypeSpec.newBuilder().setList(QueryOuterClass.TypeSpec.List.newBuilder().setElement(parameters.get(0))).build();
        }
        if ("set".equalsIgnoreCase(baseTypeName)) {
            TypeSpecs.checkParameterCount(parameters, 1, "set");
            return QueryOuterClass.TypeSpec.newBuilder().setSet(QueryOuterClass.TypeSpec.Set.newBuilder().setElement(parameters.get(0))).build();
        }
        if ("map".equalsIgnoreCase(baseTypeName)) {
            TypeSpecs.checkParameterCount(parameters, 2, "map");
            return QueryOuterClass.TypeSpec.newBuilder().setMap(QueryOuterClass.TypeSpec.Map.newBuilder().setKey(parameters.get(0)).setValue(parameters.get(1))).build();
        }
        if ("tuple".equalsIgnoreCase(baseTypeName)) {
            return QueryOuterClass.TypeSpec.newBuilder().setTuple(QueryOuterClass.TypeSpec.Tuple.newBuilder().addAllElements(parameters)).build();
        }
        throw new IllegalArgumentException(String.format("Malformed type name: unknown parameterized type %s", baseTypeName));
    }

    private static void checkParameterCount(List<QueryOuterClass.TypeSpec> parameters, int expectedCount, String baseType) {
        if (parameters.size() != expectedCount) {
            throw new IllegalArgumentException(String.format("Malformed type name: " + baseType + " takes only 1 parameter, but %d provided", parameters.size()));
        }
    }

    private static QueryOuterClass.TypeSpec parseBasicOrUdt(String typeString, Collection<QueryOuterClass.TypeSpec.Udt> udts, boolean strict) {
        if ("ascii".equalsIgnoreCase(typeString)) {
            return ASCII;
        }
        if ("bigint".equalsIgnoreCase(typeString)) {
            return BIGINT;
        }
        if ("blob".equalsIgnoreCase(typeString)) {
            return BLOB;
        }
        if ("boolean".equalsIgnoreCase(typeString)) {
            return BOOLEAN;
        }
        if ("counter".equalsIgnoreCase(typeString)) {
            return COUNTER;
        }
        if ("decimal".equalsIgnoreCase(typeString)) {
            return DECIMAL;
        }
        if ("double".equalsIgnoreCase(typeString)) {
            return DOUBLE;
        }
        if ("float".equalsIgnoreCase(typeString)) {
            return FLOAT;
        }
        if ("int".equalsIgnoreCase(typeString)) {
            return INT;
        }
        if ("timestamp".equalsIgnoreCase(typeString)) {
            return TIMESTAMP;
        }
        if ("uuid".equalsIgnoreCase(typeString)) {
            return UUID;
        }
        if ("varchar".equalsIgnoreCase(typeString) || "text".equalsIgnoreCase(typeString)) {
            return VARCHAR;
        }
        if ("varint".equalsIgnoreCase(typeString)) {
            return VARINT;
        }
        if ("timeuuid".equalsIgnoreCase(typeString)) {
            return TIMEUUID;
        }
        if ("inet".equalsIgnoreCase(typeString)) {
            return INET;
        }
        if ("date".equalsIgnoreCase(typeString)) {
            return DATE;
        }
        if ("time".equalsIgnoreCase(typeString)) {
            return TIME;
        }
        if ("smallint".equalsIgnoreCase(typeString)) {
            return SMALLINT;
        }
        if ("tinyint".equalsIgnoreCase(typeString)) {
            return TINYINT;
        }
        if ("duration".equalsIgnoreCase(typeString)) {
            return DURATION;
        }
        return TypeSpecs.findUdt(typeString, udts, strict);
    }

    private static List<QueryOuterClass.TypeSpec> splitAndParseParameters(String fullTypeName, String parameters, Collection<QueryOuterClass.TypeSpec.Udt> udts, boolean strict) {
        int currentStart;
        int idx;
        int openParam = 0;
        ArrayList<QueryOuterClass.TypeSpec> parsedParameters = new ArrayList<QueryOuterClass.TypeSpec>();
        block6: for (idx = currentStart = 0; idx < parameters.length(); ++idx) {
            switch (parameters.charAt(idx)) {
                case ',': {
                    if (openParam != 0) continue block6;
                    parsedParameters.add(TypeSpecs.extractParameter(fullTypeName, parameters, currentStart, idx, udts, strict));
                    currentStart = idx + 1;
                    continue block6;
                }
                case '<': {
                    ++openParam;
                    continue block6;
                }
                case '>': {
                    if (--openParam >= 0) continue block6;
                    throw new IllegalArgumentException("Malformed type name: " + fullTypeName + " (unmatched closing '>')");
                }
                case '\"': {
                    idx = TypeSpecs.findClosingDoubleQuote(fullTypeName, parameters, idx + 1) - 1;
                }
            }
        }
        parsedParameters.add(TypeSpecs.extractParameter(fullTypeName, parameters, currentStart, idx, udts, strict));
        return parsedParameters;
    }

    private static QueryOuterClass.TypeSpec extractParameter(String fullTypeName, String parameters, int start, int end, Collection<QueryOuterClass.TypeSpec.Udt> udts, boolean strict) {
        String parameterStr = parameters.substring(start, end);
        if (parameterStr.isEmpty()) {
            throw new IllegalArgumentException("Malformed type name: " + fullTypeName);
        }
        return TypeSpecs.parse(parameterStr, udts, strict);
    }

    private static int findClosingDoubleQuote(String fullTypeName, String str, int startIdx) {
        for (int idx = startIdx; idx < str.length(); ++idx) {
            if (str.charAt(idx) != '\"' || ++idx < str.length() && str.charAt(idx) == '\"') continue;
            return idx;
        }
        throw new IllegalArgumentException("Malformed type name: " + fullTypeName);
    }

    private static QueryOuterClass.TypeSpec findUdt(String udtName, Collection<QueryOuterClass.TypeSpec.Udt> udts, boolean strict) {
        Optional<QueryOuterClass.TypeSpec.Udt> maybeUdt = udts.stream().filter(u -> udtName.equals(u.getName())).findFirst();
        QueryOuterClass.TypeSpec.Udt udt = strict ? maybeUdt.orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find user type %s", udtName))) : maybeUdt.orElse(QueryOuterClass.TypeSpec.Udt.newBuilder().setName(udtName).build());
        return QueryOuterClass.TypeSpec.newBuilder().setUdt(udt).build();
    }

    public static boolean isFrozen(QueryOuterClass.TypeSpec type) {
        switch (type.getSpecCase()) {
            case LIST: {
                return type.getList().getFrozen();
            }
            case SET: {
                return type.getSet().getFrozen();
            }
            case MAP: {
                return type.getMap().getFrozen();
            }
            case UDT: {
                return type.getUdt().getFrozen();
            }
            case TUPLE: {
                return true;
            }
        }
        return false;
    }

    public static QueryOuterClass.TypeSpec freeze(QueryOuterClass.TypeSpec type) {
        return TypeSpecs.setFrozen(type, true);
    }

    public static QueryOuterClass.TypeSpec unfreeze(QueryOuterClass.TypeSpec type) {
        return TypeSpecs.setFrozen(type, false);
    }

    private static QueryOuterClass.TypeSpec setFrozen(QueryOuterClass.TypeSpec type, boolean newFrozen) {
        switch (type.getSpecCase()) {
            case LIST: {
                QueryOuterClass.TypeSpec.List list = type.getList();
                return list.getFrozen() == newFrozen ? type : QueryOuterClass.TypeSpec.newBuilder().setList(list.toBuilder().setFrozen(newFrozen)).build();
            }
            case SET: {
                QueryOuterClass.TypeSpec.Set set = type.getSet();
                return set.getFrozen() == newFrozen ? type : QueryOuterClass.TypeSpec.newBuilder().setSet(set.toBuilder().setFrozen(newFrozen)).build();
            }
            case MAP: {
                QueryOuterClass.TypeSpec.Map map = type.getMap();
                return map.getFrozen() == newFrozen ? type : QueryOuterClass.TypeSpec.newBuilder().setMap(map.toBuilder().setFrozen(newFrozen)).build();
            }
            case UDT: {
                QueryOuterClass.TypeSpec.Udt udt = type.getUdt();
                return udt.getFrozen() == newFrozen ? type : QueryOuterClass.TypeSpec.newBuilder().setUdt(udt.toBuilder().setFrozen(newFrozen)).build();
            }
        }
        return type;
    }

    private static QueryOuterClass.TypeSpec buildFromBasic(QueryOuterClass.TypeSpec.Basic basic) {
        return QueryOuterClass.TypeSpec.newBuilder().setBasic(basic).build();
    }

    private TypeSpecs() {
    }
}

