/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.grpc;

import com.google.protobuf.ByteString;
import io.stargate.proto.QueryOuterClass;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Values {
    public static QueryOuterClass.Value NULL = QueryOuterClass.Value.newBuilder().setNull(QueryOuterClass.Value.Null.newBuilder().build()).build();
    public static QueryOuterClass.Value UNSET = QueryOuterClass.Value.newBuilder().setUnset(QueryOuterClass.Value.Unset.newBuilder().build()).build();
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);

    public static QueryOuterClass.Value of(boolean value) {
        return QueryOuterClass.Value.newBuilder().setBoolean(value).build();
    }

    public static QueryOuterClass.Value of(LocalDate value) {
        long days = ChronoUnit.DAYS.between(EPOCH, value);
        int unsigned = (int)days - Integer.MIN_VALUE;
        return QueryOuterClass.Value.newBuilder().setDate(unsigned).build();
    }

    public static QueryOuterClass.Value of(float value) {
        return QueryOuterClass.Value.newBuilder().setFloat(value).build();
    }

    public static QueryOuterClass.Value of(short value) {
        return QueryOuterClass.Value.newBuilder().setInt(value).build();
    }

    public static QueryOuterClass.Value of(byte value) {
        return QueryOuterClass.Value.newBuilder().setInt(value).build();
    }

    public static QueryOuterClass.Value of(double value) {
        return QueryOuterClass.Value.newBuilder().setDouble(value).build();
    }

    public static QueryOuterClass.Value of(byte[] value) {
        return QueryOuterClass.Value.newBuilder().setBytes(ByteString.copyFrom((byte[])value)).build();
    }

    public static QueryOuterClass.Value of(ByteBuffer value) {
        return QueryOuterClass.Value.newBuilder().setBytes(ByteString.copyFrom((ByteBuffer)value)).build();
    }

    public static QueryOuterClass.Value of(InetAddress value) {
        return QueryOuterClass.Value.newBuilder().setInet(QueryOuterClass.Inet.newBuilder().setValue(ByteString.copyFrom((byte[])value.getAddress()))).build();
    }

    public static QueryOuterClass.Value of(long value) {
        return QueryOuterClass.Value.newBuilder().setInt(value).build();
    }

    public static QueryOuterClass.Value of(String value) {
        return QueryOuterClass.Value.newBuilder().setString(value).build();
    }

    public static QueryOuterClass.Value of(LocalTime value) {
        return QueryOuterClass.Value.newBuilder().setTime(value.toNanoOfDay()).build();
    }

    public static QueryOuterClass.Value of(BigInteger value) {
        return QueryOuterClass.Value.newBuilder().setVarint(QueryOuterClass.Varint.newBuilder().setValue(ByteString.copyFrom((byte[])value.toByteArray())).build()).build();
    }

    public static QueryOuterClass.Value of(BigDecimal value) {
        return QueryOuterClass.Value.newBuilder().setDecimal(QueryOuterClass.Decimal.newBuilder().setValue(ByteString.copyFrom((byte[])value.unscaledValue().toByteArray())).setScale(value.scale()).build()).build();
    }

    public static QueryOuterClass.Value of(UUID value) {
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.putLong(0, value.getMostSignificantBits());
        bytes.putLong(8, value.getLeastSignificantBits());
        return QueryOuterClass.Value.newBuilder().setUuid(QueryOuterClass.Uuid.newBuilder().setValue(ByteString.copyFrom((ByteBuffer)bytes))).build();
    }

    public static QueryOuterClass.Value of(QueryOuterClass.Value ... elements) {
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(Arrays.asList(elements)).build()).build();
    }

    public static QueryOuterClass.Value of(List<QueryOuterClass.Value> elements) {
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(elements).build()).build();
    }

    public static QueryOuterClass.Value of(Set<QueryOuterClass.Value> elements) {
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(elements).build()).build();
    }

    public static QueryOuterClass.Value udtOf(Map<String, QueryOuterClass.Value> fields) {
        return QueryOuterClass.Value.newBuilder().setUdt(QueryOuterClass.UdtValue.newBuilder().putAllFields(fields).build()).build();
    }

    public static QueryOuterClass.Value of(Map<QueryOuterClass.Value, QueryOuterClass.Value> fields) {
        List values = fields.entrySet().stream().flatMap(v -> Stream.of((QueryOuterClass.Value)v.getKey(), (QueryOuterClass.Value)v.getValue())).collect(Collectors.toList());
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(values).build()).build();
    }
}

