/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.grpc;

import com.google.protobuf.ByteString;
import io.stargate.grpc.CqlDuration;
import io.stargate.proto.QueryOuterClass;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Values {
    public static QueryOuterClass.Value NULL = QueryOuterClass.Value.newBuilder().setNull(QueryOuterClass.Value.Null.newBuilder().build()).build();
    public static QueryOuterClass.Value UNSET = QueryOuterClass.Value.newBuilder().setUnset(QueryOuterClass.Value.Unset.newBuilder().build()).build();
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);

    public static QueryOuterClass.Value of(boolean value) {
        return QueryOuterClass.Value.newBuilder().setBoolean(value).build();
    }

    public static QueryOuterClass.Value of(LocalDate value) {
        long days = ChronoUnit.DAYS.between(EPOCH, value);
        int unsigned = (int)days - Integer.MIN_VALUE;
        return QueryOuterClass.Value.newBuilder().setDate(unsigned).build();
    }

    public static QueryOuterClass.Value of(float value) {
        return QueryOuterClass.Value.newBuilder().setFloat(value).build();
    }

    public static QueryOuterClass.Value of(short value) {
        return QueryOuterClass.Value.newBuilder().setInt(value).build();
    }

    public static QueryOuterClass.Value of(byte value) {
        return QueryOuterClass.Value.newBuilder().setInt(value).build();
    }

    public static QueryOuterClass.Value of(double value) {
        return QueryOuterClass.Value.newBuilder().setDouble(value).build();
    }

    public static QueryOuterClass.Value of(byte[] value) {
        return QueryOuterClass.Value.newBuilder().setBytes(ByteString.copyFrom((byte[])value)).build();
    }

    public static QueryOuterClass.Value of(ByteBuffer value) {
        return QueryOuterClass.Value.newBuilder().setBytes(ByteString.copyFrom((ByteBuffer)value)).build();
    }

    public static QueryOuterClass.Value of(InetAddress value) {
        return QueryOuterClass.Value.newBuilder().setInet(QueryOuterClass.Inet.newBuilder().setValue(ByteString.copyFrom((byte[])value.getAddress()))).build();
    }

    public static QueryOuterClass.Value of(long value) {
        return QueryOuterClass.Value.newBuilder().setInt(value).build();
    }

    public static QueryOuterClass.Value of(String value) {
        return QueryOuterClass.Value.newBuilder().setString(value).build();
    }

    public static QueryOuterClass.Value of(LocalTime value) {
        return QueryOuterClass.Value.newBuilder().setTime(value.toNanoOfDay()).build();
    }

    public static QueryOuterClass.Value of(CqlDuration duration) {
        return QueryOuterClass.Value.newBuilder().setDuration(QueryOuterClass.Duration.newBuilder().setMonths(duration.getMonths()).setDays(duration.getDays()).setNanos(duration.getNanoseconds())).build();
    }

    public static QueryOuterClass.Value of(BigInteger value) {
        return QueryOuterClass.Value.newBuilder().setVarint(QueryOuterClass.Varint.newBuilder().setValue(ByteString.copyFrom((byte[])value.toByteArray())).build()).build();
    }

    public static QueryOuterClass.Value of(BigDecimal value) {
        return QueryOuterClass.Value.newBuilder().setDecimal(QueryOuterClass.Decimal.newBuilder().setValue(ByteString.copyFrom((byte[])value.unscaledValue().toByteArray())).setScale(value.scale()).build()).build();
    }

    public static QueryOuterClass.Value of(UUID value) {
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.putLong(0, value.getMostSignificantBits());
        bytes.putLong(8, value.getLeastSignificantBits());
        return QueryOuterClass.Value.newBuilder().setUuid(QueryOuterClass.Uuid.newBuilder().setValue(ByteString.copyFrom((ByteBuffer)bytes))).build();
    }

    public static QueryOuterClass.Value of(QueryOuterClass.Value ... elements) {
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(Arrays.asList(elements)).build()).build();
    }

    public static QueryOuterClass.Value of(List<QueryOuterClass.Value> elements) {
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(elements).build()).build();
    }

    public static QueryOuterClass.Value of(Set<QueryOuterClass.Value> elements) {
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(elements).build()).build();
    }

    public static QueryOuterClass.Value udtOf(Map<String, QueryOuterClass.Value> fields) {
        return QueryOuterClass.Value.newBuilder().setUdt(QueryOuterClass.UdtValue.newBuilder().putAllFields(fields).build()).build();
    }

    public static QueryOuterClass.Value of(Map<QueryOuterClass.Value, QueryOuterClass.Value> fields) {
        List values = fields.entrySet().stream().flatMap(v -> Stream.of((QueryOuterClass.Value)v.getKey(), (QueryOuterClass.Value)v.getValue())).collect(Collectors.toList());
        return QueryOuterClass.Value.newBuilder().setCollection(QueryOuterClass.Collection.newBuilder().addAllElements(values).build()).build();
    }

    public static boolean bool(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.BOOLEAN);
        return value.getBoolean();
    }

    public static int int_(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.INT);
        int intValue = (int)value.getInt();
        if ((long)intValue != value.getInt()) {
            throw new IllegalArgumentException(String.format("Valid range for int is %d to %d, got %d", Integer.MIN_VALUE, Integer.MAX_VALUE, value.getInt()));
        }
        return intValue;
    }

    public static long bigint(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.INT);
        return value.getInt();
    }

    public static short smallint(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.INT);
        short shortValue = (short)value.getInt();
        if ((long)shortValue != value.getInt()) {
            throw new IllegalArgumentException(String.format("Valid range for smallint is %d to %d, got %d", (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, value.getInt()));
        }
        return shortValue;
    }

    public static byte tinyint(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.INT);
        byte byteValue = (byte)value.getInt();
        if ((long)byteValue != value.getInt()) {
            throw new IllegalArgumentException(String.format("Valid range for tinyint is %d to %d, got %d", (byte)-128, (byte)127, value.getInt()));
        }
        return byteValue;
    }

    public static float float_(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.FLOAT);
        return value.getFloat();
    }

    public static double double_(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.DOUBLE);
        return value.getDouble();
    }

    public static ByteBuffer byteBuffer(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.BYTES);
        return value.getBytes().asReadOnlyByteBuffer();
    }

    public static byte[] bytes(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.BYTES);
        return value.getBytes().toByteArray();
    }

    public static String string(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.STRING);
        return value.getString();
    }

    public static UUID uuid(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.UUID);
        ByteString inBytes = value.getUuid().getValue();
        if (inBytes.size() != 16) {
            throw new IllegalArgumentException("Expected 16 bytes for a uuid values, got " + inBytes.size());
        }
        ByteBuffer outBytes = ByteBuffer.allocate(16);
        inBytes.copyTo(outBytes);
        return new UUID(outBytes.getLong(0), outBytes.getLong(8));
    }

    public static InetAddress inet(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.INET);
        int size = value.getInet().getValue().size();
        if (size != 4 && size != 16) {
            throw new IllegalArgumentException("Expected 4 bytes (IPv4) or 16 (IPv6) bytes for a inet values, got " + size);
        }
        try {
            return InetAddress.getByAddress(value.getInet().getValue().toByteArray());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid bytes in inet value");
        }
    }

    public static BigInteger varint(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.VARINT);
        return new BigInteger(value.getVarint().getValue().toByteArray());
    }

    public static BigDecimal decimal(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.DECIMAL);
        return new BigDecimal(new BigInteger(value.getDecimal().getValue().toByteArray()), value.getDecimal().getScale());
    }

    public static LocalDate date(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.DATE);
        int unsigned = value.getDate();
        int signed = unsigned + Integer.MIN_VALUE;
        return EPOCH.plusDays(signed);
    }

    public static LocalTime time(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.TIME);
        return LocalTime.ofNanoOfDay(value.getTime());
    }

    public static CqlDuration duration(QueryOuterClass.Value value) {
        Values.checkInnerCase(value, QueryOuterClass.Value.InnerCase.DURATION);
        QueryOuterClass.Duration duration = value.getDuration();
        return CqlDuration.newInstance(duration.getMonths(), duration.getDays(), duration.getNanos());
    }

    private static void checkInnerCase(QueryOuterClass.Value value, QueryOuterClass.Value.InnerCase expected) {
        if (value.getInnerCase() != expected) {
            throw new IllegalArgumentException(String.format("Expected %s value, received %s", new Object[]{expected, value.getInnerCase()}));
        }
    }
}

