/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.proto;

import com.salesforce.reactorgrpc.stub.ClientCalls;
import com.salesforce.reactorgrpc.stub.ServerCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.StargateGrpc;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactorStargateGrpc {
    public static final int METHODID_EXECUTE_QUERY = 0;
    public static final int METHODID_EXECUTE_QUERY_STREAM = 1;
    public static final int METHODID_EXECUTE_BATCH = 2;
    public static final int METHODID_EXECUTE_BATCH_STREAM = 3;

    private ReactorStargateGrpc() {
    }

    public static ReactorStargateStub newReactorStub(Channel channel) {
        return new ReactorStargateStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final StargateImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(StargateImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    ServerCalls.oneToOne((Object)((QueryOuterClass.Query)request), responseObserver, this.serviceImpl::executeQuery);
                    break;
                }
                case 2: {
                    ServerCalls.oneToOne((Object)((QueryOuterClass.Batch)request), responseObserver, this.serviceImpl::executeBatch);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::executeQueryStream, (CallOptions)this.serviceImpl.getCallOptions(this.methodId));
                }
                case 3: {
                    return ServerCalls.manyToMany(responseObserver, this.serviceImpl::executeBatchStream, (CallOptions)this.serviceImpl.getCallOptions(this.methodId));
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class StargateImplBase
    implements BindableService {
        public Mono<QueryOuterClass.Response> executeQuery(Mono<QueryOuterClass.Query> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<QueryOuterClass.StreamingResponse> executeQueryStream(Flux<QueryOuterClass.Query> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<QueryOuterClass.Response> executeBatch(Mono<QueryOuterClass.Batch> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flux<QueryOuterClass.StreamingResponse> executeBatchStream(Flux<QueryOuterClass.Batch> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)StargateGrpc.getServiceDescriptor()).addMethod(StargateGrpc.getExecuteQueryMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(StargateGrpc.getExecuteQueryStreamMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(StargateGrpc.getExecuteBatchMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(StargateGrpc.getExecuteBatchStreamMethod(), io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 3))).build();
        }

        protected CallOptions getCallOptions(int methodId) {
            return null;
        }
    }

    public static final class ReactorStargateStub
    extends AbstractStub<ReactorStargateStub> {
        private StargateGrpc.StargateStub delegateStub;

        private ReactorStargateStub(Channel channel) {
            super(channel);
            this.delegateStub = StargateGrpc.newStub(channel);
        }

        private ReactorStargateStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = StargateGrpc.newStub(channel).build(channel, callOptions);
        }

        protected ReactorStargateStub build(Channel channel, CallOptions callOptions) {
            return new ReactorStargateStub(channel, callOptions);
        }

        public Mono<QueryOuterClass.Response> executeQuery(Mono<QueryOuterClass.Query> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::executeQuery, (CallOptions)this.getCallOptions());
        }

        public Flux<QueryOuterClass.StreamingResponse> executeQueryStream(Flux<QueryOuterClass.Query> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::executeQueryStream, (CallOptions)this.getCallOptions());
        }

        public Mono<QueryOuterClass.Response> executeBatch(Mono<QueryOuterClass.Batch> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::executeBatch, (CallOptions)this.getCallOptions());
        }

        public Flux<QueryOuterClass.StreamingResponse> executeBatchStream(Flux<QueryOuterClass.Batch> reactorRequest) {
            return ClientCalls.manyToMany(reactorRequest, this.delegateStub::executeBatchStream, (CallOptions)this.getCallOptions());
        }

        public Mono<QueryOuterClass.Response> executeQuery(QueryOuterClass.Query reactorRequest) {
            return ClientCalls.oneToOne((Mono)Mono.just((Object)reactorRequest), this.delegateStub::executeQuery, (CallOptions)this.getCallOptions());
        }

        public Mono<QueryOuterClass.Response> executeBatch(QueryOuterClass.Batch reactorRequest) {
            return ClientCalls.oneToOne((Mono)Mono.just((Object)reactorRequest), this.delegateStub::executeBatch, (CallOptions)this.getCallOptions());
        }
    }
}

