/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleStateChecker
extends HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(BundleStateChecker.class);
    private final BundleContext context;

    public BundleStateChecker(BundleContext context) {
        this.context = context;
    }

    protected HealthCheck.Result check() {
        ArrayList<String> inactive = new ArrayList<String>();
        for (Bundle bundle : this.context.getBundles()) {
            if (bundle.getState() == 32) continue;
            inactive.add(bundle.getSymbolicName());
        }
        if (inactive.isEmpty()) {
            return HealthCheck.Result.healthy((String)"All bundles active");
        }
        logger.warn("Inactive bundles: {}", inactive);
        return HealthCheck.Result.unhealthy((String)("Inactive bundles: " + inactive));
    }
}

