/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class CPUGaugeMetricSet
implements MetricSet {
    final CentralProcessor processor;
    private long tickTime;
    private final long[] prevTicks;
    private final long[] curTicks;
    private final int TIME_BETWEEN_TICKS = 950;

    public CPUGaugeMetricSet() {
        this.processor = new SystemInfo().getHardware().getProcessor();
        this.prevTicks = new long[CentralProcessor.TickType.values().length];
        this.curTicks = new long[CentralProcessor.TickType.values().length];
    }

    protected CPUGaugeMetricSet(CentralProcessor processor, long[] curTicks, long[] prevTicks) {
        this.processor = processor;
        this.prevTicks = prevTicks;
        this.curTicks = curTicks;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>();
        gauges.put("load", this::getSystemCpuLoad);
        gauges.put("user", () -> this.getTick(CentralProcessor.TickType.USER));
        gauges.put("nice", () -> this.getTick(CentralProcessor.TickType.NICE));
        gauges.put("sys", () -> this.getTick(CentralProcessor.TickType.SYSTEM));
        gauges.put("idle", () -> this.getTick(CentralProcessor.TickType.IDLE));
        gauges.put("iowait", () -> this.getTick(CentralProcessor.TickType.IOWAIT));
        return Collections.unmodifiableMap(gauges);
    }

    private Double getSystemCpuLoad() {
        long now = System.currentTimeMillis();
        if (now - this.tickTime > 950L) {
            this.updateSystemTicks();
        }
        return this.processor.getSystemCpuLoadBetweenTicks(this.prevTicks);
    }

    private Double getTick(CentralProcessor.TickType tickType) {
        long now = System.currentTimeMillis();
        if (now - this.tickTime > 950L) {
            this.updateSystemTicks();
        }
        long user = this.curTicks[CentralProcessor.TickType.USER.getIndex()] - this.prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = this.curTicks[CentralProcessor.TickType.NICE.getIndex()] - this.prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = this.curTicks[CentralProcessor.TickType.SYSTEM.getIndex()] - this.prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = this.curTicks[CentralProcessor.TickType.IDLE.getIndex()] - this.prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = this.curTicks[CentralProcessor.TickType.IOWAIT.getIndex()] - this.prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = this.curTicks[CentralProcessor.TickType.IRQ.getIndex()] - this.prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = this.curTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - this.prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = this.curTicks[CentralProcessor.TickType.STEAL.getIndex()] - this.prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCPU = user + nice + sys + idle + iowait + irq + softirq + steal;
        switch (tickType) {
            case USER: {
                return (double)user / (double)totalCPU;
            }
            case NICE: {
                return (double)nice / (double)totalCPU;
            }
            case SYSTEM: {
                return (double)sys / (double)totalCPU;
            }
            case IDLE: {
                return (double)idle / (double)totalCPU;
            }
            case IOWAIT: {
                return (double)iowait / (double)totalCPU;
            }
        }
        return 0.0;
    }

    private void updateSystemTicks() {
        long[] ticks;
        for (long tick : ticks = this.processor.getSystemCpuLoadTicks()) {
            if (tick == 0L) continue;
            this.tickTime = System.currentTimeMillis();
            System.arraycopy(this.curTicks, 0, this.prevTicks, 0, this.curTicks.length);
            System.arraycopy(ticks, 0, this.curTicks, 0, ticks.length);
            return;
        }
    }
}

