/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.stargate.health.BundleService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/checker")
@Produces(value={"text/plain"})
@Singleton
public class CheckerResource {
    private static final Logger logger = LoggerFactory.getLogger(CheckerResource.class);
    @Inject
    private BundleService bundleService;
    @Inject
    private HealthCheckRegistry healthCheckRegistry;

    public CheckerResource() {
    }

    CheckerResource(BundleService bundleService, HealthCheckRegistry healthCheckRegistry) {
        this.bundleService = bundleService;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    @GET
    @Path(value="/liveness")
    public Response checkLiveness() {
        HealthCheck bundleHealthCheck = this.healthCheckRegistry.getHealthCheck("bundles");
        if (bundleHealthCheck == null || !bundleHealthCheck.execute().isHealthy()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"DOWN").build();
        }
        HealthCheck schemaHealthCheck = this.healthCheckRegistry.getHealthCheck("schema-agreement");
        if (schemaHealthCheck == null || !schemaHealthCheck.execute().isHealthy()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"DOWN").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"UP").build();
    }

    @GET
    @Path(value="/readiness")
    public Response checkReadiness(@QueryParam(value="check") Set<String> checks) {
        boolean checkAll = checks == null || checks.isEmpty();
        HashSet<String> requiredChecks = new HashSet<String>(checkAll ? this.bundleService.defaultHealthCheckNames() : checks);
        SortedMap status = this.healthCheckRegistry.runHealthChecks((name, healthCheck) -> checkAll || requiredChecks.contains(name));
        boolean ready = true;
        for (Map.Entry e : status.entrySet()) {
            String name2 = (String)e.getKey();
            requiredChecks.remove(name2);
            boolean healthy = ((HealthCheck.Result)e.getValue()).isHealthy();
            if (healthy) continue;
            logger.warn("Failed health check: {}", (Object)name2);
            ready = false;
        }
        if (!requiredChecks.isEmpty()) {
            logger.warn("Missing required health checks: {}", requiredChecks);
            ready = false;
        }
        if (ready) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"READY").build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"NOT READY").build();
    }
}

