/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.health.HealthCheck;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreHealthChecker
extends HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(DataStoreHealthChecker.class);
    private final DataStoreFactory dataStoreFactory;

    public DataStoreHealthChecker(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    protected HealthCheck.Result check() {
        try {
            DataStore dataStore = this.dataStoreFactory.createInternal();
            CompletableFuture rs = dataStore.queryBuilder().select().column("cluster_name").column("schema_version").from("system", "local").build().execute(new Object[0]);
            Row row = ((ResultSet)rs.get()).one();
            String clusterName = row.getString("cluster_name");
            UUID schemaVersion = row.getUuid("schema_version");
            if (clusterName == null || clusterName.isEmpty()) {
                return HealthCheck.Result.unhealthy((String)("Empty cluster name: " + clusterName));
            }
            if (schemaVersion == null) {
                return HealthCheck.Result.unhealthy((String)"Null schema version");
            }
            return HealthCheck.Result.healthy((String)"DataStore is operational");
        }
        catch (Exception e) {
            logger.warn("checkIsReady failed with {}", (Object)e.getMessage(), (Object)e);
            return HealthCheck.Result.unhealthy((String)("Unable to access DataStore: " + e));
        }
    }
}

