/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.stargate.core.activator.BaseActivator;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.core.metrics.api.MetricsScraper;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.health.BundleStateChecker;
import io.stargate.health.DataStoreHealthChecker;
import io.stargate.health.SchemaAgreementChecker;
import io.stargate.health.StorageHealthChecker;
import io.stargate.health.WebImpl;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckerActivator
extends BaseActivator {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckerActivator.class);
    public static final String MODULE_NAME = "health-checker";
    public static final String BUNDLES_CHECK_NAME = "bundles";
    public static final String STORAGE_CHECK_NAME = "storage";
    public static final String DATA_STORE_CHECK_NAME = "datastore";
    public static final String SCHEMA_CHECK_NAME = "schema-agreement";
    private final BaseActivator.ServicePointer<Metrics> metrics = BaseActivator.ServicePointer.create(Metrics.class);
    private final BaseActivator.ServicePointer<MetricsScraper> metricsScraper = BaseActivator.ServicePointer.create(MetricsScraper.class);
    private final BaseActivator.ServicePointer<HttpMetricsTagProvider> httpTagProvider = BaseActivator.ServicePointer.create(HttpMetricsTagProvider.class);
    private final BaseActivator.ServicePointer<DataStoreFactory> dataStoreFactory = BaseActivator.ServicePointer.create(DataStoreFactory.class);
    private final BaseActivator.ServicePointer<HealthCheckRegistry> healthCheckRegistry = BaseActivator.ServicePointer.create(HealthCheckRegistry.class);

    public HealthCheckerActivator() {
        super("healthchecker");
    }

    public synchronized void stop(BundleContext context) {
        ((HealthCheckRegistry)this.healthCheckRegistry.get()).unregister(BUNDLES_CHECK_NAME);
        ((HealthCheckRegistry)this.healthCheckRegistry.get()).unregister(DATA_STORE_CHECK_NAME);
        ((HealthCheckRegistry)this.healthCheckRegistry.get()).unregister(STORAGE_CHECK_NAME);
    }

    @Nullable
    protected BaseActivator.ServiceAndProperties createService() {
        log.info("Starting healthchecker....");
        try {
            ((HealthCheckRegistry)this.healthCheckRegistry.get()).register(BUNDLES_CHECK_NAME, (HealthCheck)new BundleStateChecker(this.context));
            ((HealthCheckRegistry)this.healthCheckRegistry.get()).register(DATA_STORE_CHECK_NAME, (HealthCheck)new DataStoreHealthChecker((DataStoreFactory)this.dataStoreFactory.get()));
            ((HealthCheckRegistry)this.healthCheckRegistry.get()).register(STORAGE_CHECK_NAME, (HealthCheck)new StorageHealthChecker((DataStoreFactory)this.dataStoreFactory.get()));
            ((HealthCheckRegistry)this.healthCheckRegistry.get()).register(SCHEMA_CHECK_NAME, (HealthCheck)new SchemaAgreementChecker(this.context));
            WebImpl web = new WebImpl(this.context, (Metrics)this.metrics.get(), (MetricsScraper)this.metricsScraper.get(), (HttpMetricsTagProvider)this.httpTagProvider.get(), (HealthCheckRegistry)this.healthCheckRegistry.get());
            web.start();
            log.info("Started healthchecker....");
        }
        catch (Exception e) {
            log.error("Failed", (Throwable)e);
        }
        return null;
    }

    protected List<BaseActivator.ServicePointer<?>> dependencies() {
        return Arrays.asList(this.metrics, this.metricsScraper, this.httpTagProvider, this.healthCheckRegistry, this.dataStoreFactory);
    }
}

