/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.health.HealthCheck;
import io.stargate.db.Persistence;
import java.util.Collection;
import java.util.Iterator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAgreementChecker
extends HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(SchemaAgreementChecker.class);
    private static final String DB_PERSISTENCE_IDENTIFIER = System.getProperty("stargate.persistence_id", "CassandraPersistence");
    private static final String DB_PERSISTENCE_FILTER = String.format("(Identifier=%s)", DB_PERSISTENCE_IDENTIFIER);
    private final BundleContext context;

    public SchemaAgreementChecker(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HealthCheck.Result check() {
        try {
            Collection services = this.context.getServiceReferences(Persistence.class, DB_PERSISTENCE_FILTER);
            Iterator iterator = services.iterator();
            if (!iterator.hasNext()) return HealthCheck.Result.healthy((String)"Persistence is not initialized yet");
            ServiceReference service = (ServiceReference)iterator.next();
            Persistence persistence = (Persistence)this.context.getService(service);
            try {
                if (persistence.isInSchemaAgreement()) {
                    HealthCheck.Result result = HealthCheck.Result.healthy((String)"All schemas agree");
                    return result;
                }
                if (persistence.isInSchemaAgreementWithStorage()) {
                    HealthCheck.Result result = HealthCheck.Result.healthy((String)"Local schema is in agreement with storage nodes");
                    return result;
                }
                if (persistence.isSchemaAgreementAchievable()) {
                    HealthCheck.Result result = HealthCheck.Result.healthy((String)"Waiting for schema agreement");
                    return result;
                }
                HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"Schema agreement is not achievable");
                return result;
            }
            finally {
                this.context.ungetService(service);
            }
        }
        catch (Exception e) {
            logger.warn("Schema agreement check failed with {}", (Object)e.getMessage(), (Object)e);
            return HealthCheck.Result.unhealthy((String)("Unable to check schema agreement: " + e));
        }
    }
}

