/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dropwizard.Application;
import io.dropwizard.cli.Cli;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.ResourceConfigurationSourceProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.JarLocation;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.core.metrics.api.MetricsScraper;
import io.stargate.health.ApplicationConfiguration;
import io.stargate.health.BundleService;
import io.stargate.health.CPUGaugeMetricSet;
import io.stargate.health.CheckerResource;
import io.stargate.health.PrometheusResource;
import io.stargate.metrics.jersey.MetricsBinder;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class Server
extends Application<ApplicationConfiguration> {
    private final BundleService bundleService;
    private final Metrics metrics;
    private final MetricsScraper metricsScraper;
    private final HttpMetricsTagProvider httpMetricsTagProvider;
    private final HealthCheckRegistry healthCheckRegistry;

    public Server(BundleService bundleService, Metrics metrics, MetricsScraper metricsScraper, HttpMetricsTagProvider httpMetricsTagProvider, HealthCheckRegistry healthCheckRegistry) {
        this.bundleService = bundleService;
        this.metrics = metrics;
        this.metricsScraper = metricsScraper;
        this.httpMetricsTagProvider = httpMetricsTagProvider;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public void run(String ... arguments) {
        Bootstrap bootstrap = new Bootstrap((Application)this);
        this.addDefaultCommands(bootstrap);
        this.initialize((Bootstrap<ApplicationConfiguration>)bootstrap);
        this.registerJvmMetrics();
        Cli cli = new Cli(new JarLocation(((Object)((Object)this)).getClass()), bootstrap, (OutputStream)System.out, (OutputStream)System.err);
        cli.run(arguments).ifPresent(arg_0 -> ((Server)this).onFatalError(arg_0));
    }

    public void run(ApplicationConfiguration applicationConfiguration, Environment environment) {
        environment.getObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        environment.getObjectMapper().registerModule((Module)new JavaTimeModule());
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(Server.this.bundleService).to(BundleService.class);
                this.bind(Server.this.healthCheckRegistry).to(HealthCheckRegistry.class);
                this.bind(Server.this.metricsScraper).to(MetricsScraper.class);
            }
        });
        environment.jersey().register(CheckerResource.class);
        environment.jersey().register(PrometheusResource.class);
        MetricsBinder metricsBinder = new MetricsBinder(this.metrics, this.httpMetricsTagProvider, "health-checker");
        metricsBinder.register(environment.jersey());
        environment.jersey().property("jersey.config.server.response.setStatusOverSendError", (Object)true);
    }

    public void initialize(Bootstrap<ApplicationConfiguration> bootstrap) {
        super.initialize(bootstrap);
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new ResourceConfigurationSourceProvider());
        bootstrap.setMetricRegistry(this.metrics.getRegistry("health-checker"));
        bootstrap.setHealthCheckRegistry(this.healthCheckRegistry);
    }

    private void registerJvmMetrics() {
        MetricRegistry topLevelRegistry = this.metrics.getRegistry();
        topLevelRegistry.register("jvm.attribute", (Metric)new JvmAttributeGaugeSet());
        topLevelRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        topLevelRegistry.register("jvm.classloader", (Metric)new ClassLoadingGaugeSet());
        topLevelRegistry.register("jvm.filedescriptor", (Metric)new FileDescriptorRatioGauge());
        topLevelRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        topLevelRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        topLevelRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        topLevelRegistry.register("cpu", (Metric)new CPUGaugeMetricSet());
    }

    protected void bootstrapLogging() {
    }
}

