/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.health;

import com.codahale.metrics.health.HealthCheck;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.Replication;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableTable;
import io.stargate.db.schema.Table;
import io.stargate.health.DataStoreHealthChecker;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageHealthChecker
extends HealthCheck {
    private static final UUID STARGATE_NODE_ID = UUID.randomUUID();
    private static final Logger logger = LoggerFactory.getLogger(DataStoreHealthChecker.class);
    private static final boolean SHOULD_CREATE_KS_AND_TABLE = Boolean.parseBoolean(System.getProperty("stargate.health_check.data_store.create_ks_and_table", "false"));
    private static final String KEYSPACE_NAME = System.getProperty("stargate.health_check.data_store.keyspace_name", "data_store_health_check");
    private static final String TABLE_NAME = System.getProperty("stargate.health_check.data_store.table_name", "health_table");
    private static final int INSERT_TTL_SECONDS = 600;
    private static final boolean STORAGE_CHECK_ENABLED = Boolean.parseBoolean(System.getProperty("stargate.health_check.data_store.enabled", "false"));
    private static final int REPLICATION_FACTOR = Integer.parseInt(System.getProperty("stargate.health_check.data_store.replication_factor", "1"));
    private static final String PK_COLUMN_NAME = "pk";
    private static final String VALUE_COLUMN_NAME = "value";
    private static final String VALUE_COLUMN_VALUE = "dummy_value";
    private static final Table EXPECTED_TABLE = ImmutableTable.builder().keyspace(KEYSPACE_NAME).name(TABLE_NAME).addColumns(new Column[]{ImmutableColumn.create((String)"pk", (Column.Kind)Column.Kind.PartitionKey, (Column.ColumnType)Column.Type.Uuid), ImmutableColumn.create((String)"value", (Column.Kind)Column.Kind.Regular, (Column.ColumnType)Column.Type.Text)}).build();
    private final DataStoreFactory dataStoreFactory;

    public StorageHealthChecker(DataStoreFactory dataStoreFactory) throws ExecutionException, InterruptedException {
        this.dataStoreFactory = dataStoreFactory;
        if (SHOULD_CREATE_KS_AND_TABLE) {
            this.ensureTableExists(dataStoreFactory.createInternal());
        }
    }

    protected HealthCheck.Result check() throws Exception {
        if (!STORAGE_CHECK_ENABLED) {
            return HealthCheck.Result.healthy((String)"Storage check disabled");
        }
        try {
            DataStore dataStore = this.dataStoreFactory.createInternal();
            Instant writeTimestamp = Instant.now();
            dataStore.execute(dataStore.queryBuilder().insertInto(KEYSPACE_NAME, TABLE_NAME).value(PK_COLUMN_NAME, (Object)STARGATE_NODE_ID).value(VALUE_COLUMN_NAME, (Object)VALUE_COLUMN_VALUE).ttl(Integer.valueOf(600)).timestamp(Long.valueOf(writeTimestamp.toEpochMilli())).build().bind(new Object[0]), ConsistencyLevel.LOCAL_QUORUM).get();
            ResultSet rs = (ResultSet)dataStore.execute(dataStore.queryBuilder().select().writeTimeColumn(VALUE_COLUMN_NAME).from(KEYSPACE_NAME, TABLE_NAME).where(PK_COLUMN_NAME, Predicate.EQ, (Object)STARGATE_NODE_ID).build().bind(new Object[0]), ConsistencyLevel.LOCAL_QUORUM).get();
            Row row = rs.one();
            Instant timestampRead = Instant.ofEpochMilli(row.getLong(0));
            if (this.isGreaterThanOrEqual(timestampRead, writeTimestamp)) {
                return HealthCheck.Result.healthy((String)"Storage is operational");
            }
            return HealthCheck.Result.unhealthy((String)"Storage did not return the proper data.");
        }
        catch (Exception e) {
            logger.warn("checkIsReady failed with {}", (Object)e.getMessage(), (Object)e);
            return HealthCheck.Result.unhealthy((String)("Unable to access Storage: " + e));
        }
    }

    private boolean isGreaterThanOrEqual(Instant timestampRead, Instant expectedTimestamp) {
        if (timestampRead == null) {
            return false;
        }
        return expectedTimestamp.equals(timestampRead) || timestampRead.isAfter(expectedTimestamp);
    }

    private void ensureTableExists(DataStore dataStore) throws ExecutionException, InterruptedException {
        dataStore.execute(dataStore.queryBuilder().create().keyspace(KEYSPACE_NAME).ifNotExists().withReplication(Replication.simpleStrategy((int)REPLICATION_FACTOR)).build().bind(new Object[0])).get();
        dataStore.execute(dataStore.queryBuilder().create().table(KEYSPACE_NAME, TABLE_NAME).ifNotExists().column((Collection)EXPECTED_TABLE.columns()).build().bind(new Object[0])).get();
    }
}

