/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.tenant.impl;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.mockito.InjectMock;
import io.stargate.sgv2.api.common.tenant.TenantResolver;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@QuarkusTest
@TestProfile(value=Profile.class)
class SubdomainTenantResolverWithRegexTest {
    @Inject
    Instance<TenantResolver> tenantResolver;
    @InjectMock(returnsDeepMocks=true)
    RoutingContext routingContext;

    SubdomainTenantResolverWithRegexTest() {
    }

    @Nested
    class Resolve {
        Resolve() {
        }

        @Test
        public void happyPath() {
            Mockito.when((Object)SubdomainTenantResolverWithRegexTest.this.routingContext.request().host()).thenReturn((Object)"09cedbf6-9086-42bb-93ac-e497682227ba-eu-west-1.domain.host");
            Optional result = ((TenantResolver)SubdomainTenantResolverWithRegexTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverWithRegexTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).contains((Object)"09cedbf6-9086-42bb-93ac-e497682227ba");
        }

        @Test
        public void tooShort() {
            Mockito.when((Object)SubdomainTenantResolverWithRegexTest.this.routingContext.request().host()).thenReturn((Object)"09cedbf6-9086-42bb-93ac-e497682227b.domain.host");
            Optional result = ((TenantResolver)SubdomainTenantResolverWithRegexTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverWithRegexTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).isEmpty();
        }

        @Test
        public void regexNotMatched() {
            Mockito.when((Object)SubdomainTenantResolverWithRegexTest.this.routingContext.request().host()).thenReturn((Object)"xyz.domain.host");
            Optional result = ((TenantResolver)SubdomainTenantResolverWithRegexTest.this.tenantResolver.get()).resolve(SubdomainTenantResolverWithRegexTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).isEmpty();
        }
    }

    public static class Profile
    implements QuarkusTestProfile {
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().put((Object)"stargate.multi-tenancy.enabled", (Object)"true").put((Object)"stargate.multi-tenancy.tenant-resolver.type", (Object)"subdomain").put((Object)"stargate.multi-tenancy.tenant-resolver.subdomain.max-chars", (Object)"36").put((Object)"stargate.multi-tenancy.tenant-resolver.subdomain.regex", (Object)"[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}").build();
        }
    }
}

