/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.tenant.impl;

import io.stargate.sgv2.api.common.config.MultiTenancyConfig;
import io.stargate.sgv2.api.common.tenant.TenantResolver;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.ws.rs.core.SecurityContext;

public class SubdomainTenantResolver
implements TenantResolver {
    private final Pattern validationPattern;
    private final int maxChars;

    public SubdomainTenantResolver(MultiTenancyConfig.TenantResolverConfig.SubdomainTenantResolverConfig config) {
        this.maxChars = config.maxChars().isPresent() ? config.maxChars().getAsInt() : -1;
        if (config.regex().isPresent()) {
            String regex = config.regex().get();
            this.validationPattern = Pattern.compile(regex);
        } else {
            this.validationPattern = null;
        }
    }

    @Override
    public Optional<String> resolve(RoutingContext context, SecurityContext securityContext) {
        String host = context.request().host();
        int index = host.indexOf(46);
        if (index > 0) {
            boolean matches;
            String tenantId = host.substring(0, index);
            if (this.maxChars >= 0 && this.maxChars < tenantId.length()) {
                tenantId = tenantId.substring(0, this.maxChars);
            }
            if (null != this.validationPattern && !(matches = this.validationPattern.matcher(tenantId).matches())) {
                return Optional.empty();
            }
            return Optional.of(tenantId);
        }
        return Optional.empty();
    }
}

