/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.token.impl;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.mockito.InjectMock;
import io.stargate.sgv2.api.common.token.CassandraTokenResolver;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@QuarkusTest
@TestProfile(value=Profile.class)
class HeaderTokenResolverTest {
    @Inject
    Instance<CassandraTokenResolver> tokenResolver;
    @InjectMock(returnsDeepMocks=true)
    RoutingContext routingContext;

    HeaderTokenResolverTest() {
    }

    @Nested
    class Resolve {
        Resolve() {
        }

        @Test
        public void happyPath() {
            String token = RandomStringUtils.randomAlphanumeric((int)16);
            Mockito.when((Object)HeaderTokenResolverTest.this.routingContext.request().getHeader("x-some-header")).thenReturn((Object)token);
            Optional result = ((CassandraTokenResolver)HeaderTokenResolverTest.this.tokenResolver.get()).resolve(HeaderTokenResolverTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).contains((Object)token);
        }

        @Test
        public void noHeader() {
            Mockito.when((Object)HeaderTokenResolverTest.this.routingContext.request().getHeader("x-some-header")).thenReturn(null);
            Optional result = ((CassandraTokenResolver)HeaderTokenResolverTest.this.tokenResolver.get()).resolve(HeaderTokenResolverTest.this.routingContext, null);
            Assertions.assertThat((Optional)result).isEmpty();
        }
    }

    public static class Profile
    implements QuarkusTestProfile {
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().put((Object)"stargate.auth.token-resolver.type", (Object)"header").put((Object)"stargate.auth.token-resolver.header.header-name", (Object)"x-some-header").build();
        }
    }
}

