/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.exception;

import io.quarkus.arc.lookup.LookupIfProperty;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;

@LookupIfProperty(name="stargate.exception-mappers.enabled", stringValue="true", lookupIfMissing=true)
public class ConstraintViolationExceptionMapper {
    @ServerExceptionMapper
    public RestResponse<ApiError> constraintViolationException(ConstraintViolationException exception) {
        Set violations = exception.getConstraintViolations();
        String violationMessages = violations.stream().map(ConstraintViolation::getMessage).distinct().collect(Collectors.joining(", "));
        String message = String.format("Request invalid: %s.", violationMessages);
        int code = Response.Status.BAD_REQUEST.getStatusCode();
        ApiError error = new ApiError(message, code);
        return RestResponse.ResponseBuilder.create((Response.StatusType)Response.Status.BAD_REQUEST, (Object)error).build();
    }
}

