/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.properties.datastore.configuration;

import io.quarkus.grpc.GrpcClient;
import io.quarkus.runtime.Startup;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.config.DataStoreConfig;
import io.stargate.sgv2.api.common.properties.datastore.DataStoreProperties;
import io.stargate.sgv2.api.common.properties.datastore.impl.DataStorePropertiesImpl;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStorePropertiesConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DataStorePropertiesConfiguration.class);

    @Produces
    @ApplicationScoped
    @Startup
    DataStoreProperties configuration(@GrpcClient(value="bridge") StargateBridgeGrpc.StargateBridgeBlockingStub bridge, DataStoreConfig dataStoreConfig) {
        DataStorePropertiesImpl fromConfig = new DataStorePropertiesImpl(dataStoreConfig.secondaryIndexesEnabled(), dataStoreConfig.saiEnabled(), dataStoreConfig.loggedBatchesEnabled());
        if (dataStoreConfig.ignoreBridge()) {
            LOG.info("DataStoreConfig.ignoreBridge() == true, will use pre-configured defaults");
            return fromConfig;
        }
        LOG.info("DataStoreConfig.ignoreBridge() == false, will try to fetch data store metadata using the Bridge");
        AtomicInteger callCount = new AtomicInteger(0);
        try {
            Schema.SupportedFeaturesResponse supportedFeatures = this.fetchSupportedFeatures(bridge, callCount);
            DataStorePropertiesImpl props = new DataStorePropertiesImpl(supportedFeatures.getSecondaryIndexes(), supportedFeatures.getSai(), supportedFeatures.getLoggedBatches());
            LOG.info("Successfully fetched data store metadata ({} retries)", (Object)(callCount.get() - 1));
            return props;
        }
        catch (Exception e) {
            String msgBase = "Failed to fetch data store metadata ({} retries)".formatted(callCount.get() - 1);
            if (dataStoreConfig.bridgeFallbackEnabled()) {
                LOG.warn(msgBase + ", 'bridgeFallbackEnabled' == true, will return fallback data store metadata", (Throwable)e);
                return fromConfig;
            }
            LOG.warn(msgBase + ", 'bridgeFallbackEnabled' == false, will fail");
            throw e;
        }
    }

    @Retry(maxRetries=4, delay=3L, delayUnit=ChronoUnit.SECONDS, maxDuration=60L, durationUnit=ChronoUnit.SECONDS)
    protected Schema.SupportedFeaturesResponse fetchSupportedFeatures(StargateBridgeGrpc.StargateBridgeBlockingStub bridge, AtomicInteger callCount) {
        callCount.incrementAndGet();
        try {
            return bridge.getSupportedFeatures(Schema.SupportedFeaturesRequest.newBuilder().build());
        }
        catch (Exception e) {
            LOG.info("Data store metadata fetch using Bridge failed (call #{}/5), problem: ({}) {}", new Object[]{callCount.get(), e.getClass().getName(), e.getMessage()});
            throw e;
        }
    }
}

