/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.exception;

import io.stargate.sgv2.api.common.exception.ConstraintViolationExceptionMapper;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import java.util.Collections;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.reactive.RestResponse;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ConstraintViolationExceptionMapperTest {
    @Test
    public void happyPath() {
        String message = "Email must not be empty";
        ConstraintViolation violation = (ConstraintViolation)Mockito.mock(ConstraintViolation.class);
        Mockito.when((Object)violation.getMessage()).thenReturn((Object)message);
        ConstraintViolationException error = new ConstraintViolationException(Collections.singleton(violation));
        ConstraintViolationExceptionMapper mapper = new ConstraintViolationExceptionMapper();
        try (RestResponse response = mapper.constraintViolationException(error);){
            Assertions.assertThat((int)response.getStatus()).isEqualTo(400);
            Assertions.assertThat((String)((ApiError)response.getEntity()).description()).isEqualTo("Request invalid: %s.".formatted(message));
        }
    }
}

