/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.smallrye.mutiny.helpers.test.UniAssertSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.grpc.RetriableStargateBridge;
import io.stargate.sgv2.api.common.grpc.qualifier.Retriable;
import io.stargate.sgv2.common.bridge.BridgeTest;
import io.stargate.sgv2.common.testprofiles.NoGlobalResourcesTestProfile;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@QuarkusTest
class RetriableStargateBridgeTest
extends BridgeTest {
    @Retriable
    @Inject
    RetriableStargateBridge bridge;

    RetriableStargateBridgeTest() {
    }

    @Nested
    @TestProfile(value=Profile.class)
    class Disabled {
        Disabled() {
        }

        @Test
        public void disabledNoRetries() {
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.UNAVAILABLE;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            QueryOuterClass.Query request = QueryOuterClass.Query.newBuilder().build();
            Throwable result = ((UniAssertSubscriber)RetriableStargateBridgeTest.this.bridge.executeQuery(request).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitFailure().getFailure();
            Assertions.assertThat((Throwable)result).isInstanceOfSatisfying(StatusRuntimeException.class, e -> Assertions.assertThat((Object)e.getStatus()).isEqualTo((Object)Status.UNAVAILABLE));
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.eq((Object)request), (StreamObserver)ArgumentMatchers.any());
        }

        public static class Profile
        implements NoGlobalResourcesTestProfile {
            public Map<String, String> getConfigOverrides() {
                return ImmutableMap.builder().put((Object)"stargate.grpc.retries.enabled", (Object)"false").put((Object)"stargate.grpc.retries.status-codes", (Object)"UNAVAILABLE,NOT_FOUND").build();
            }
        }
    }

    @Nested
    @TestProfile(value=Profile.class)
    class Enabled {
        Enabled() {
        }

        @Test
        public void notRetriedOnResponse() {
            QueryOuterClass.Response response = QueryOuterClass.Response.newBuilder().build();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                observer.onNext((Object)response);
                observer.onCompleted();
                return null;
            }).when((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            QueryOuterClass.Query request = QueryOuterClass.Query.newBuilder().build();
            ((UniAssertSubscriber)RetriableStargateBridgeTest.this.bridge.executeQuery(request).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitItem().assertItem((Object)response).assertCompleted();
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.eq((Object)request), (StreamObserver)ArgumentMatchers.any());
        }

        @Test
        public void notRetriedWrongStatusCode() {
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.UNIMPLEMENTED;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            QueryOuterClass.Query request = QueryOuterClass.Query.newBuilder().build();
            Throwable result = ((UniAssertSubscriber)RetriableStargateBridgeTest.this.bridge.executeQuery(request).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitFailure().getFailure();
            Assertions.assertThat((Throwable)result).isInstanceOfSatisfying(StatusRuntimeException.class, e -> Assertions.assertThat((Object)e.getStatus()).isEqualTo((Object)Status.UNIMPLEMENTED));
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.eq((Object)request), (StreamObserver)ArgumentMatchers.any());
        }

        @Test
        public void retried() {
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.UNAVAILABLE;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            QueryOuterClass.Query request = QueryOuterClass.Query.newBuilder().build();
            Throwable result = ((UniAssertSubscriber)RetriableStargateBridgeTest.this.bridge.executeQuery(request).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitFailure().getFailure();
            Assertions.assertThat((Throwable)result).isInstanceOfSatisfying(StatusRuntimeException.class, e -> Assertions.assertThat((Object)e.getStatus()).isEqualTo((Object)Status.UNAVAILABLE));
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)RetriableStargateBridgeTest.this.bridgeService, (VerificationMode)Mockito.times((int)3))).executeQuery((QueryOuterClass.Query)ArgumentMatchers.eq((Object)request), (StreamObserver)ArgumentMatchers.any());
        }

        @Test
        public void retriedAdditionalStatusCode() {
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
                StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
                Status status = Status.NOT_FOUND;
                observer.onError((Throwable)new StatusRuntimeException(status));
                return null;
            }).when((Object)RetriableStargateBridgeTest.this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
            QueryOuterClass.Query request = QueryOuterClass.Query.newBuilder().build();
            Throwable result = ((UniAssertSubscriber)RetriableStargateBridgeTest.this.bridge.executeQuery(request).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitFailure().getFailure();
            Assertions.assertThat((Throwable)result).isInstanceOfSatisfying(StatusRuntimeException.class, e -> Assertions.assertThat((Object)e.getStatus()).isEqualTo((Object)Status.NOT_FOUND));
            ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)RetriableStargateBridgeTest.this.bridgeService, (VerificationMode)Mockito.times((int)3))).executeQuery((QueryOuterClass.Query)ArgumentMatchers.eq((Object)request), (StreamObserver)ArgumentMatchers.any());
        }

        public static class Profile
        implements NoGlobalResourcesTestProfile {
            public Map<String, String> getConfigOverrides() {
                return ImmutableMap.builder().put((Object)"stargate.grpc.retries.status-codes", (Object)"UNAVAILABLE,NOT_FOUND").put((Object)"stargate.grpc.retries.max-attempts", (Object)"2").build();
            }
        }
    }
}

