/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.bridge;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;

public class ValidatingPaginator {
    public static final int MAGIC = 1020304050;
    private final int pageSize;
    private final int offset;
    private int nextOffset = -1;

    private ValidatingPaginator(int pageSize, int offset) {
        this.pageSize = pageSize;
        this.offset = offset;
    }

    public static ValidatingPaginator of(int pageSize) {
        return new ValidatingPaginator(pageSize, -1);
    }

    public static ValidatingPaginator of(int pageSize, Optional<ByteBuffer> pagingState) {
        int offset = pagingState.map(buf -> {
            int magic = buf.getInt();
            Assertions.assertThat((int)magic).isEqualTo(1020304050);
            return buf.getInt();
        }).orElse(0);
        return new ValidatingPaginator(pageSize, offset);
    }

    public <T> List<T> filter(List<T> data) {
        int from = Math.max(this.offset, 0);
        if (from >= data.size()) {
            return Collections.emptyList();
        }
        int to = from + this.pageSize;
        if (to > data.size()) {
            to = data.size();
        } else {
            this.nextOffset = to;
        }
        return data.subList(from, to);
    }

    public ByteBuffer pagingState() {
        if (this.nextOffset < 0) {
            return null;
        }
        return ValidatingPaginator.pagingState(this.nextOffset);
    }

    public ByteBuffer pagingStateForRow(int index) {
        return ValidatingPaginator.pagingState(this.offset + index + 1);
    }

    private static ByteBuffer pagingState(int offset) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putInt(1020304050);
        buffer.putInt(offset);
        buffer.rewind();
        return buffer;
    }
}

