/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.grpc.Metadata;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.GrpcMetadataConfig;
import io.stargate.sgv2.api.common.grpc.SourceApiQualifier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class GrpcMetadataResolver {
    private final Metadata.Key<String> tenantIdKey;
    private final Metadata.Key<String> cassandraTokenKey;
    private final Metadata defaultMetadata;

    @Inject
    public GrpcMetadataResolver(GrpcMetadataConfig config, @SourceApiQualifier String sourceApi) {
        this.tenantIdKey = Metadata.Key.of((String)config.tenantIdKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        this.cassandraTokenKey = Metadata.Key.of((String)config.cassandraTokenKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata.Key sourceApiKey = Metadata.Key.of((String)config.sourceApiKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata defaultMetadata = new Metadata();
        defaultMetadata.put(sourceApiKey, (Object)sourceApi);
        this.defaultMetadata = defaultMetadata;
    }

    public Metadata getDefaultMetadata() {
        return this.defaultMetadata;
    }

    public Metadata getMetadata(StargateRequestInfo requestInfo) {
        Metadata metadata = new Metadata();
        requestInfo.getTenantId().ifPresent(t -> metadata.put(this.tenantIdKey, t));
        requestInfo.getCassandraToken().ifPresent(t -> metadata.put(this.cassandraTokenKey, t));
        metadata.merge(this.defaultMetadata);
        return metadata;
    }
}

