/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.MetricsConfig;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;

@ApplicationScoped
public class TenantRequestMetricsFilter {
    private static final Pattern USER_AGENT_SPLIT = Pattern.compile("[\\s/]");
    private static final String UNKNOWN_VALUE = "unknown";
    private final MeterRegistry meterRegistry;
    private final MetricsConfig.TenantRequestCounterConfig config;
    private final StargateRequestInfo requestInfo;
    private final Tag errorTrue;
    private final Tag errorFalse;
    Tag tenantUnknown;

    @Inject
    public TenantRequestMetricsFilter(MeterRegistry meterRegistry, StargateRequestInfo requestInfo, MetricsConfig metricsConfig) {
        this.meterRegistry = meterRegistry;
        this.requestInfo = requestInfo;
        this.config = metricsConfig.tenantRequestCounter();
        this.errorTrue = Tag.of((String)this.config.errorTag(), (String)"true");
        this.errorFalse = Tag.of((String)this.config.errorTag(), (String)"false");
        this.tenantUnknown = Tag.of((String)this.config.tenantTag(), (String)UNKNOWN_VALUE);
    }

    @ServerResponseFilter
    public void record(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.config.enabled()) {
            Tag tenantTag = this.requestInfo.getTenantId().map(id -> Tag.of((String)this.config.tenantTag(), (String)id)).orElse(this.tenantUnknown);
            boolean error = responseContext.getStatus() >= 500;
            Tag errorTag = error ? this.errorTrue : this.errorFalse;
            Tags tags = Tags.of((Tag[])new Tag[]{tenantTag, errorTag});
            if (this.config.userAgentTagEnabled()) {
                String userAgentValue = this.getUserAgentValue(requestContext);
                tags = tags.and(new Tag[]{Tag.of((String)this.config.userAgentTag(), (String)userAgentValue)});
            }
            this.meterRegistry.counter(this.config.metricName(), (Iterable)tags).increment();
        }
    }

    private String getUserAgentValue(ContainerRequestContext requestContext) {
        String headerString = requestContext.getHeaderString("user-agent");
        if (null != headerString && !headerString.isBlank()) {
            String[] split = USER_AGENT_SPLIT.split(headerString);
            if (split.length > 0) {
                return split[0];
            }
            return headerString;
        }
        return UNKNOWN_VALUE;
    }
}

