/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.util.Optional;

@ConfigMapping(prefix="stargate.auth")
public interface AuthConfig {
    @Valid
    public HeaderBasedAuthConfig headerBased();

    @Valid
    public TokenResolverConfig tokenResolver();

    public static interface TokenResolverConfig {
        @WithDefault(value="principal")
        public Optional<@Pattern(regexp="header|principal|fixed|custom") String> type();

        @Valid
        public HeaderTokenResolverConfig header();

        @Valid
        public FixedTokenResolverConfig fixed();

        public static interface FixedTokenResolverConfig {
            public Optional<String> token();
        }

        public static interface HeaderTokenResolverConfig {
            @NotBlank
            @WithDefault(value="X-Cassandra-Token")
            public String headerName();
        }
    }

    public static interface HeaderBasedAuthConfig {
        @WithDefault(value="true")
        public boolean enabled();

        @NotBlank
        @WithDefault(value="X-Cassandra-Token")
        public String headerName();

        @WithDefault(value="${stargate.exception-mappers.enabled:true}")
        public boolean customChallengeEnabled();
    }
}

