/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.tenant.configuration;

import io.quarkus.arc.lookup.LookupIfProperty;
import io.stargate.sgv2.api.common.config.MultiTenancyConfig;
import io.stargate.sgv2.api.common.tenant.TenantResolver;
import io.stargate.sgv2.api.common.tenant.impl.FixedTenantResolver;
import io.stargate.sgv2.api.common.tenant.impl.SubdomainTenantResolver;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.Optional;

public class TenantConfiguration {
    @Produces
    @ApplicationScoped
    @LookupIfProperty.List(value={@LookupIfProperty(name="stargate.multi-tenancy.tenant-resolver.type", stringValue="subdomain"), @LookupIfProperty(name="stargate.multi-tenancy.enabled", stringValue="true")})
    TenantResolver subdomainTenantResolver(MultiTenancyConfig config) {
        return new SubdomainTenantResolver(config.tenantResolver().subdomain());
    }

    @Produces
    @ApplicationScoped
    @LookupIfProperty.List(value={@LookupIfProperty(name="stargate.multi-tenancy.tenant-resolver.type", stringValue="fixed"), @LookupIfProperty(name="stargate.multi-tenancy.enabled", stringValue="true")})
    TenantResolver fixedTenantResolver(MultiTenancyConfig config) {
        return new FixedTenantResolver(config.tenantResolver().fixed());
    }

    @Produces
    @ApplicationScoped
    @LookupIfProperty.List(value={@LookupIfProperty(name="stargate.multi-tenancy.tenant-resolver.type", stringValue="noop", lookupIfMissing=true), @LookupIfProperty(name="stargate.multi-tenancy.enabled", stringValue="false", lookupIfMissing=true)})
    TenantResolver noopTenantResolver() {
        return (context, securityContext) -> Optional.empty();
    }
}

