/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import io.grpc.StatusRuntimeException;
import io.smallrye.mutiny.Uni;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.bridge.proto.StargateBridge;
import io.stargate.sgv2.api.common.config.GrpcConfig;
import io.stargate.sgv2.api.common.grpc.retries.GrpcRetryPredicate;

public class RetriableStargateBridge
implements StargateBridge {
    private final StargateBridge delegate;
    private final GrpcRetryPredicate predicate;
    private final boolean enabled;
    private final int maxAttempts;

    public RetriableStargateBridge(StargateBridge delegate, GrpcRetryPredicate predicate, GrpcConfig grpcConfig) {
        this.delegate = delegate;
        this.predicate = predicate;
        this.enabled = grpcConfig.retries().enabled();
        this.maxAttempts = grpcConfig.retries().maxAttempts();
    }

    @Override
    public Uni<QueryOuterClass.Response> executeQuery(QueryOuterClass.Query request) {
        return this.withRetries(this.delegate.executeQuery(request));
    }

    @Override
    public Uni<Schema.QueryWithSchemaResponse> executeQueryWithSchema(Schema.QueryWithSchema request) {
        return this.withRetries(this.delegate.executeQueryWithSchema(request));
    }

    @Override
    public Uni<QueryOuterClass.Response> executeBatch(QueryOuterClass.Batch request) {
        return this.withRetries(this.delegate.executeBatch(request));
    }

    @Override
    public Uni<Schema.CqlKeyspaceDescribe> describeKeyspace(Schema.DescribeKeyspaceQuery request) {
        return this.withRetries(this.delegate.describeKeyspace(request));
    }

    @Override
    public Uni<Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(Schema.AuthorizeSchemaReadsRequest request) {
        return this.withRetries(this.delegate.authorizeSchemaReads(request));
    }

    @Override
    public Uni<Schema.SupportedFeaturesResponse> getSupportedFeatures(Schema.SupportedFeaturesRequest request) {
        return this.withRetries(this.delegate.getSupportedFeatures(request));
    }

    private <T> Uni<T> withRetries(Uni<T> source) {
        if (!this.enabled) {
            return source;
        }
        return source.onFailure(t -> {
            if (t instanceof StatusRuntimeException) {
                StatusRuntimeException sre = (StatusRuntimeException)t;
                return this.predicate.test(sre);
            }
            return false;
        }).retry().atMost((long)this.maxAttempts);
    }
}

