/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.metrics;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.stargate.sgv2.api.common.testprofiles.FixedTenantTestProfile;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=Profile.class)
class TenantRequestMetricsTagProviderTest {
    TenantRequestMetricsTagProviderTest() {
    }

    @Test
    public void record() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/testingTagProvider", new Object[0])).then()).statusCode(200);
        String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().asString();
        List meteredLines = Arrays.stream(result.split(System.getProperty("line.separator"))).filter(line -> line.startsWith("http_server_requests")).collect(Collectors.toList());
        Assertions.assertThat(meteredLines).anySatisfy(metric -> Assertions.assertThat((String)metric).contains(new CharSequence[]{"tenant=\"mickey-mouse\""}));
    }

    @Path(value="testingTagProvider")
    public static class TestingResource {
        @GET
        @Produces(value={"text/plain"})
        public String greet() {
            return "hello";
        }
    }

    public static class Profile
    extends FixedTenantTestProfile {
        @Override
        public Map<String, String> getConfigOverrides() {
            Map<String, String> configOverrides = super.getConfigOverrides();
            return ImmutableMap.builder().putAll(configOverrides).put((Object)"quarkus.micrometer.export.prometheus.path", (Object)"/metrics").build();
        }
    }
}

