/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.logging;

import io.stargate.sgv2.api.common.StargateRequestInfo;
import io.stargate.sgv2.api.common.config.LoggingConfig;
import io.stargate.sgv2.api.common.logging.LoggingFilter;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.testcontainers.shaded.org.bouncycastle.util.Strings;

public class LoggingFilterTest {
    private static final String TEST_TENANT = "test-tenant";
    private static final String TEST_TENANT_2 = "test-tenant-2";

    @Test
    public void testIsLoggingNotAllowedWithDefaults() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, false, null, null, null, null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isFalse();
    }

    @Test
    public void testIsLoggingAllowedWhenEnabled() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, null, null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
    }

    @Test
    public void testIsLoggingNotAllowedForTenant() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, Collections.singleton(TEST_TENANT_2), null, null, null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isFalse();
    }

    @Test
    public void testIsLoggingAllowedForTenant() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, Collections.singleton(TEST_TENANT), null, null, null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
    }

    @Test
    public void testIsLoggingNotAllowedForPath() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, Collections.singleton("/api/rest/keyspaces2"), null, null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isFalse();
    }

    @Test
    public void testIsLoggingAllowedForPath() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, Collections.singleton("/api/rest/keyspaces"), null, null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
    }

    @Test
    public void testIsLoggingNotAllowedForPathPrefixes() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, Collections.singleton("/api/rest/v1"), null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isFalse();
    }

    @Test
    public void testIsLoggingAllowedForPathPrefixes() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, Set.of("/api/rest/", "/api/"), null, null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
    }

    @Test
    public void testIsLoggingNotAllowedForErrorCodes() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, null, Collections.singleton("400"), null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isFalse();
    }

    @Test
    public void testIsLoggingAllowedForErrorCodes() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, null, Collections.singleton("400"), null);
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)400);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
    }

    @Test
    public void testIsLoggingNotAllowedForMethods() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, null, null, Collections.singleton("POST"));
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isFalse();
    }

    @Test
    public void testIsLoggingAllowedForMethods() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, null, null, null, null, Collections.singleton("POST"));
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/api/rest/keyspaces");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)200);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
    }

    @Test
    public void testLoggingWithNoRequestBody() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, Collections.singleton(TEST_TENANT), Collections.singleton("/v2/keyspaces/clientkeyspace/clienttable"), Collections.singleton("/v2/keyspaces/"), Collections.singleton("400"), Collections.singleton("POST"));
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/v2/keyspaces/clientkeyspace/clienttable");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)400);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
        Method buildRequestInfoMethod = loggingFilter.getClass().getDeclaredMethod("buildRequestInfo", ContainerRequestContext.class, ContainerResponseContext.class, Boolean.TYPE);
        buildRequestInfoMethod.setAccessible(true);
        String requestInfo = (String)buildRequestInfoMethod.invoke((Object)loggingFilter, requestContext, responseContext, true);
        String expectedRequestInfo = String.format("REQUEST INFO :: %s %s %s %s %s", TEST_TENANT, 400, "POST", "/v2/keyspaces/clientkeyspace/clienttable", "");
        Assertions.assertThat((String)requestInfo).isEqualTo(expectedRequestInfo);
    }

    @Test
    public void testLoggingWithRequestBody() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ContainerRequestContext requestContext = (ContainerRequestContext)Mockito.mock(ContainerRequestContext.class);
        ContainerResponseContext responseContext = (ContainerResponseContext)Mockito.mock(ContainerResponseContext.class);
        LoggingConfig loggingConfig = (LoggingConfig)Mockito.mock(LoggingConfig.class);
        StargateRequestInfo stargateRequestInfo = (StargateRequestInfo)Mockito.mock(StargateRequestInfo.class);
        this.mockLoggingConfig(loggingConfig, true, Collections.singleton(TEST_TENANT), Collections.singleton("/v2/keyspaces/clientkeyspace/clienttable"), Collections.singleton("/v2/keyspaces/"), Collections.singleton("400"), Collections.singleton("POST"));
        this.mockStargateRequestInfo(stargateRequestInfo);
        Mockito.when((Object)requestContext.getUriInfo()).thenReturn((Object)((UriInfo)Mockito.mock(UriInfo.class)));
        Mockito.when((Object)requestContext.getUriInfo().getPath()).thenReturn((Object)"/v2/keyspaces/clientkeyspace/clienttable");
        Mockito.when((Object)requestContext.getMethod()).thenReturn((Object)"POST");
        String requestBody = "{\"name\":\"test\"}";
        Mockito.when((Object)requestContext.getEntityStream()).thenReturn((Object)new ByteArrayInputStream(Strings.toByteArray((String)requestBody)));
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)400);
        Mockito.when((Object)responseContext.getStatus()).thenReturn((Object)400);
        LoggingFilter loggingFilter = new LoggingFilter(stargateRequestInfo, loggingConfig);
        Method isAllowedMethod = loggingFilter.getClass().getDeclaredMethod("isLoggingAllowed", ContainerRequestContext.class, ContainerResponseContext.class);
        isAllowedMethod.setAccessible(true);
        boolean isAllowed = (Boolean)isAllowedMethod.invoke((Object)loggingFilter, requestContext, responseContext);
        Assertions.assertThat((boolean)isAllowed).isTrue();
        Method buildRequestInfoMethod = loggingFilter.getClass().getDeclaredMethod("buildRequestInfo", ContainerRequestContext.class, ContainerResponseContext.class, Boolean.TYPE);
        buildRequestInfoMethod.setAccessible(true);
        String requestInfo = (String)buildRequestInfoMethod.invoke((Object)loggingFilter, requestContext, responseContext, true);
        String expectedRequestInfo = String.format("REQUEST INFO :: %s %s %s %s %s", TEST_TENANT, 400, "POST", "/v2/keyspaces/clientkeyspace/clienttable", requestBody);
        Assertions.assertThat((String)requestInfo).isEqualTo(expectedRequestInfo);
    }

    private void mockStargateRequestInfo(StargateRequestInfo stargateRequestInfo) {
        Mockito.when((Object)stargateRequestInfo.getTenantId()).thenReturn(Optional.of(TEST_TENANT));
    }

    private void mockLoggingConfig(LoggingConfig loggingConfig, boolean loggingEnabled, Set<String> tenants, Set<String> paths, Set<String> pathPrefixes, Set<String> errorCodes, Set<String> methods) {
        Mockito.when((Object)loggingConfig.enabled()).thenReturn((Object)loggingEnabled);
        Mockito.when((Object)loggingConfig.enabledTenants()).thenReturn(tenants != null ? Optional.of(tenants) : Optional.of(Collections.singleton("all")));
        Mockito.when((Object)loggingConfig.enabledPaths()).thenReturn(paths != null ? Optional.of(paths) : Optional.of(Collections.singleton("all")));
        Mockito.when((Object)loggingConfig.enabledPathPrefixes()).thenReturn(pathPrefixes != null ? Optional.of(pathPrefixes) : Optional.of(Collections.singleton("all")));
        Mockito.when((Object)loggingConfig.enabledErrorCodes()).thenReturn(errorCodes != null ? Optional.of(errorCodes) : Optional.of(Collections.singleton("all")));
        Mockito.when((Object)loggingConfig.enabledMethods()).thenReturn(methods != null ? Optional.of(methods) : Optional.of(Collections.singleton("all")));
    }
}

