/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.cql.builder;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.api.common.cql.ExpressionUtils;
import io.stargate.sgv2.api.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.api.common.cql.builder.Predicate;
import io.stargate.sgv2.api.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.api.common.cql.builder.Term;
import io.stargate.sgv2.api.common.cql.builder.ValueModifier;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueryBuilderValuesTest {
    public static final QueryOuterClass.Value INT_VALUE1 = Values.of((long)1L);
    public static final QueryOuterClass.Value INT_VALUE2 = Values.of((long)10L);
    public static final QueryOuterClass.Value TEXT_VALUE = Values.of((String)"a");
    public static final QueryOuterClass.Value TEST_NAME_VALUE = Values.of((String)"tim");
    public static final QueryOuterClass.Value TEST_AGE_VALUE = Values.of((long)25L);
    public static final QueryOuterClass.Value TEST_GENDER_VALUE = Values.of((String)"male");
    public static final QueryOuterClass.Value TEST_KEY_VALUE = Values.of((String)"(1,'1')");

    @Test
    public void shouldBindDirectInsertValues() {
        QueryOuterClass.Query query = new QueryBuilder().insertInto("ks", "tbl").value("c1", (Object)INT_VALUE1).value("c2", (Object)TEXT_VALUE).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("INSERT INTO ks.tbl (c1, c2) VALUES (?, ?)");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE});
    }

    @Test
    public void shouldBindSimilarityCosine() {
        QueryOuterClass.Value vectorValue = Values.of(List.of(Values.of((float)1.0f)));
        QueryOuterClass.Query query = new QueryBuilder().select().column(new String[]{"a", "b", "c"}).similarityCosine("vector_column", vectorValue).from("ks", "tbl").limit(Integer.valueOf(1)).vsearch("vector_column").build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT a, b, c, SIMILARITY_COSINE(vector_column, ?) FROM ks.tbl ORDER BY vector_column ANN OF ? LIMIT 1");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{vectorValue});
    }

    @Test
    public void shouldBindSimilarityDotProduct() {
        QueryOuterClass.Value vectorValue = Values.of(List.of(Values.of((float)1.0f)));
        QueryOuterClass.Query query = new QueryBuilder().select().column(new String[]{"a", "b", "c"}).similarityDotProduct("vector_column", vectorValue).from("ks", "tbl").limit(Integer.valueOf(1)).vsearch("vector_column").build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT a, b, c, SIMILARITY_DOT_PRODUCT(vector_column, ?) FROM ks.tbl ORDER BY vector_column ANN OF ? LIMIT 1");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{vectorValue});
    }

    @Test
    public void shouldBindSimilarityEuclidean() {
        QueryOuterClass.Value vectorValue = Values.of(List.of(Values.of((float)1.0f)));
        QueryOuterClass.Query query = new QueryBuilder().select().column(new String[]{"a", "b", "c"}).similarityEuclidean("vector_column", vectorValue).from("ks", "tbl").limit(Integer.valueOf(1)).vsearch("vector_column").build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT a, b, c, SIMILARITY_EUCLIDEAN(vector_column, ?) FROM ks.tbl ORDER BY vector_column ANN OF ? LIMIT 1");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{vectorValue});
    }

    @Test
    public void shouldBindValueModifiers() {
        Variable expression = Variable.of((Object)BuiltCondition.of((String)"k", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1));
        QueryOuterClass.Query query = new QueryBuilder().update("ks", "tbl").value(ValueModifier.set((String)"c1", (QueryOuterClass.Value)INT_VALUE1)).value(ValueModifier.of((ValueModifier.Target)ValueModifier.Target.mapValue((String)"c2", (Term)Term.of((QueryOuterClass.Value)TEXT_VALUE)), (ValueModifier.Operation)ValueModifier.Operation.APPEND, (QueryOuterClass.Value)INT_VALUE2)).where((Expression)expression).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("UPDATE ks.tbl SET c1 = ?, c2[?] += ? WHERE k = ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE, INT_VALUE2, INT_VALUE1});
    }

    @Test
    public void shouldBindDirectWhereValues() {
        And expression = ExpressionUtils.andOf((Expression[])new Expression[]{Variable.of((Object)BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1)), Variable.of((Object)BuiltCondition.of((String)"c2", (Predicate)Predicate.EQ, (QueryOuterClass.Value)TEXT_VALUE))});
        QueryOuterClass.Query query = new QueryBuilder().select().from("ks", "tbl").where((Expression)expression).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE (c1 = ? AND c2 = ?)");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE});
    }

    @Test
    public void shouldBindBuiltConditionsInWhere() {
        And expression = ExpressionUtils.andOf((Expression[])new Expression[]{Variable.of((Object)BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1)), Variable.of((Object)BuiltCondition.of((BuiltCondition.LHS)BuiltCondition.LHS.mapAccess((String)"c2", (QueryOuterClass.Value)TEXT_VALUE), (Predicate)Predicate.GT, (QueryOuterClass.Value)INT_VALUE2))});
        QueryOuterClass.Query query = new QueryBuilder().select().from("ks", "tbl").where((Expression)expression).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE (c1 = ? AND c2[?] > ?)");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, TEXT_VALUE, INT_VALUE2});
    }

    @Test
    public void shouldBindDirectIfValues() {
        Variable expression = Variable.of((Object)BuiltCondition.of((String)"k", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1));
        QueryOuterClass.Query query = new QueryBuilder().delete().from("ks", "tbl").where((Expression)expression).ifs("c1", Predicate.EQ, (Object)INT_VALUE2).ifs("c2", Predicate.EQ, (Object)TEXT_VALUE).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("DELETE FROM ks.tbl WHERE k = ? IF c1 = ? AND c2 = ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2, TEXT_VALUE});
    }

    @Test
    public void shouldBindBuiltConditionsInIfs() {
        Variable expression = Variable.of((Object)BuiltCondition.of((String)"k", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1));
        QueryOuterClass.Query query = new QueryBuilder().delete().from("ks", "tbl").where((Expression)expression).ifs(BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE2)).ifs(BuiltCondition.of((BuiltCondition.LHS)BuiltCondition.LHS.mapAccess((String)"c2", (QueryOuterClass.Value)TEXT_VALUE), (Predicate)Predicate.GT, (QueryOuterClass.Value)INT_VALUE1)).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("DELETE FROM ks.tbl WHERE k = ? IF c1 = ? AND c2[?] > ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2, TEXT_VALUE, INT_VALUE1});
    }

    @Test
    public void shouldGenerateUniqueMarkerNames() {
        And expression = ExpressionUtils.andOf((Expression[])new Expression[]{Variable.of((Object)BuiltCondition.of((String)"k", (Predicate)Predicate.GT, (QueryOuterClass.Value)INT_VALUE1)), Variable.of((Object)BuiltCondition.of((String)"k", (Predicate)Predicate.LTE, (QueryOuterClass.Value)INT_VALUE2))});
        QueryOuterClass.Query query = new QueryBuilder().delete().from("ks", "tbl").where((Expression)expression).build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("DELETE FROM ks.tbl WHERE (k > ? AND k <= ?)");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2});
    }

    @Test
    public void shouldBindValuesInQueryOrder() {
        Variable expression = Variable.of((Object)BuiltCondition.of((String)"c1", (Predicate)Predicate.EQ, (QueryOuterClass.Value)INT_VALUE1));
        QueryBuilder.QueryBuilder__23 select = new QueryBuilder().select().from("ks", "tbl");
        select.limit(INT_VALUE2);
        select.where((Expression)expression);
        QueryOuterClass.Query query = select.build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * FROM ks.tbl WHERE c1 = ? LIMIT ?");
        Assertions.assertThat((List)query.getValues().getValuesList()).containsExactly((Object[])new QueryOuterClass.Value[]{INT_VALUE1, INT_VALUE2});
    }

    @Test
    public void shouldFailIfMixingValuesAndExplicitMarkers() {
        Assertions.assertThatThrownBy(() -> new QueryBuilder().select().from("tbl").where("a", Predicate.EQ, (Object)INT_VALUE1).where("b", Predicate.EQ, (Object)Term.marker())).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void shouldAllowCQLStatement() {
        QueryOuterClass.Query query = new QueryBuilder().cql("SELECT * from system.local").build();
        Assertions.assertThat((String)query.getCql()).isEqualTo("SELECT * from system.local");
    }

    @Test
    public void expressionQueryBuilderTest() {
        BuiltCondition name = BuiltCondition.of((String)"name", (Predicate)Predicate.EQ, (QueryOuterClass.Value)TEST_NAME_VALUE);
        BuiltCondition age = BuiltCondition.of((String)"age", (Predicate)Predicate.EQ, (QueryOuterClass.Value)TEST_AGE_VALUE);
        BuiltCondition gender = BuiltCondition.of((String)"gender", (Predicate)Predicate.CONTAINS, (QueryOuterClass.Value)TEST_GENDER_VALUE);
        And expr = ExpressionUtils.andOf((Expression[])new Expression[]{Variable.of((Object)name), ExpressionUtils.orOf((Expression[])new Expression[]{Variable.of((Object)age), Variable.of((Object)gender)})});
        QueryOuterClass.Query query = new QueryBuilder().select().from("testKS", "testCollection").where((Expression)expr).limit(Integer.valueOf(1)).build();
        Assertions.assertThat((String)query.getCql()).isIn(new Object[]{"SELECT * FROM \"testKS\".\"testCollection\" WHERE (name = ? AND (age = ? OR gender CONTAINS ?)) LIMIT 1", "SELECT * FROM \"testKS\".\"testCollection\" WHERE (name = ? AND (gender CONTAINS ? OR age = ?)) LIMIT 1", "SELECT * FROM \"testKS\".\"testCollection\" WHERE ((age = ? OR gender CONTAINS ?) AND name = ?) LIMIT 1", "SELECT * FROM \"testKS\".\"testCollection\" WHERE ((gender CONTAINS ? OR age = ?) AND name = ?) LIMIT 1"});
        Assertions.assertThat((List)query.getValues().getValuesList()).contains((Object[])new QueryOuterClass.Value[]{TEST_NAME_VALUE, TEST_AGE_VALUE, TEST_GENDER_VALUE});
    }

    @Test
    public void expressionQueryBuilderKeyTest() {
        BuiltCondition key = BuiltCondition.of((String)"key", (Predicate)Predicate.EQ, (QueryOuterClass.Value)TEST_KEY_VALUE);
        BuiltCondition name = BuiltCondition.of((String)"name", (Predicate)Predicate.CONTAINS, (QueryOuterClass.Value)TEST_NAME_VALUE);
        BuiltCondition gender = BuiltCondition.of((String)"gender", (Predicate)Predicate.CONTAINS, (QueryOuterClass.Value)TEST_GENDER_VALUE);
        And expr = ExpressionUtils.andOf((Expression[])new Expression[]{Variable.of((Object)key), Or.of((Expression)Variable.of((Object)name), (Expression)Variable.of((Object)gender))});
        QueryOuterClass.Query query = new QueryBuilder().select().from("testKS", "testCollection").where((Expression)expr).build();
        Assertions.assertThat((String)query.getCql()).isIn(new Object[]{"SELECT * FROM \"testKS\".\"testCollection\" WHERE ((name CONTAINS ? OR gender CONTAINS ?) AND key = ?)", "SELECT * FROM \"testKS\".\"testCollection\" WHERE ((gender CONTAINS ? OR name CONTAINS ?) AND key = ?)", "SELECT * FROM \"testKS\".\"testCollection\" WHERE (key = ? AND (gender CONTAINS ? OR name CONTAINS ?))", "SELECT * FROM \"testKS\".\"testCollection\" WHERE (key = ? AND (name CONTAINS ? OR gender CONTAINS ?))"});
        Assertions.assertThat((List)query.getValues().getValuesList()).contains((Object[])new QueryOuterClass.Value[]{TEST_KEY_VALUE, TEST_NAME_VALUE, TEST_GENDER_VALUE});
    }
}

