/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.eclipse.microprofile.config.ConfigProvider;

public final class IntegrationTestUtils {
    public static final String AUTH_TOKEN_PROP = "stargate.int-test.auth-token";
    public static final String CASSANDRA_HOST_PROP = "stargate.int-test.cassandra.host";
    public static final String CASSANDRA_CQL_PORT_PROP = "stargate.int-test.cassandra.cql-port";
    public static final String STARGATE_CQL_PORT_PROP = "stargate.int-test.coordinator.cql-port";
    public static final String CASSANDRA_AUTH_ENABLED_PROP = "stargate.int-test.cassandra.auth-enabled";
    public static final String CASSANDRA_USERNAME_PROP = "stargate.int-test.cassandra.username";
    public static final String CASSANDRA_PASSWORD_PROP = "stargate.int-test.cassandra.password";
    public static final String PERSISTENCE_MODULE_PROP = "stargate.int-test.cluster.persistence";
    public static final String PERSISTENCE_SUPPORTS_VSEARCH = "stargate.int-test.feature.vsearch";

    private IntegrationTestUtils() {
    }

    public static String getAuthToken() {
        return IntegrationTestUtils.getAuthToken("");
    }

    public static String getAuthToken(String defaultIfMissing) {
        return System.getProperty(AUTH_TOKEN_PROP, defaultIfMissing);
    }

    public static InetSocketAddress getCassandraCqlAddress() {
        String host = Objects.requireNonNull(System.getProperty(CASSANDRA_HOST_PROP), "Expected system property %s to be set".formatted(CASSANDRA_HOST_PROP));
        Integer port = Integer.getInteger(CASSANDRA_CQL_PORT_PROP);
        Objects.requireNonNull(port, "Expected system property %s to be set to an integer (got %s)".formatted(CASSANDRA_CQL_PORT_PROP, System.getProperty(CASSANDRA_CQL_PORT_PROP)));
        return new InetSocketAddress(host, (int)port);
    }

    public static boolean isCassandraAuthEnabled() {
        return Boolean.parseBoolean(System.getProperty(CASSANDRA_AUTH_ENABLED_PROP, "false"));
    }

    public static String getCassandraUsername() {
        return System.getProperty(CASSANDRA_USERNAME_PROP, "cassandra");
    }

    public static String getCassandraPassword() {
        return System.getProperty(CASSANDRA_PASSWORD_PROP, "cassandra");
    }

    public static String getPersistenceModule() {
        return System.getProperty(PERSISTENCE_MODULE_PROP, "");
    }

    public static boolean isDSE() {
        return "persistence-dse-6.8".equals(IntegrationTestUtils.getPersistenceModule());
    }

    public static boolean supportsSASI() {
        return IntegrationTestUtils.isDSE();
    }

    public static boolean supportsMaterializedViews() {
        return IntegrationTestUtils.isDSE();
    }

    public static boolean supportsVSearch() {
        return Boolean.parseBoolean(System.getProperty(PERSISTENCE_SUPPORTS_VSEARCH, "false"));
    }

    public static int getTestPort() {
        try {
            return (Integer)ConfigProvider.getConfig().getValue("quarkus.http.test-port", Integer.class);
        }
        catch (Exception e) {
            return Integer.parseInt(System.getProperty("quarkus.http.test-port"));
        }
    }
}

