/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.metrics;

import com.google.common.collect.ImmutableMap;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.stargate.sgv2.api.common.metrics.TenantRequestMetricsFilterTest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=Profile.class)
class TenantRequestMetricsFilterWithUserAgentTagTest {
    TenantRequestMetricsFilterWithUserAgentTagTest() {
    }

    @Test
    public void happyPath() {
        ((ValidatableResponse)((Response)RestAssured.given().when().header("user-agent", (Object)"python-requests/2.27.1", new Object[0]).get("/testing", new Object[0])).then()).statusCode(200);
        String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().asString();
        List meteredLines = Arrays.stream(result.split(System.getProperty("line.separator"))).filter(line -> line.startsWith("test_metrics_total")).collect(Collectors.toList());
        Assertions.assertThat(meteredLines).anySatisfy(metric -> ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)metric).contains(new CharSequence[]{"tenantTag=\"mickey-mouse\""})).contains(new CharSequence[]{"errorTag=\"false\""})).contains(new CharSequence[]{"agentTag=\"python-requests\""}));
    }

    @Test
    public void spaceInAgentName() {
        ((ValidatableResponse)((Response)RestAssured.given().when().header("user-agent", (Object)"Symfony HttpClient/Curl", new Object[0]).get("/testing", new Object[0])).then()).statusCode(200);
        String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().asString();
        List meteredLines = Arrays.stream(result.split(System.getProperty("line.separator"))).filter(line -> line.startsWith("test_metrics_total")).collect(Collectors.toList());
        Assertions.assertThat(meteredLines).anySatisfy(metric -> ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)metric).contains(new CharSequence[]{"tenantTag=\"mickey-mouse\""})).contains(new CharSequence[]{"errorTag=\"false\""})).contains(new CharSequence[]{"agentTag=\"Symfony\""}));
    }

    @Test
    public void blankHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().header("user-agent", (Object)" ", new Object[0]).when().get("/testing", new Object[0])).then()).statusCode(200);
        String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().asString();
        List meteredLines = Arrays.stream(result.split(System.getProperty("line.separator"))).filter(line -> line.startsWith("test_metrics_total")).collect(Collectors.toList());
        Assertions.assertThat(meteredLines).anySatisfy(metric -> ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)metric).contains(new CharSequence[]{"tenantTag=\"mickey-mouse\""})).contains(new CharSequence[]{"errorTag=\"false\""})).contains(new CharSequence[]{"agentTag=\"unknown\""}));
    }

    public static class Profile
    extends TenantRequestMetricsFilterTest.Profile {
        @Override
        public Map<String, String> getConfigOverrides() {
            Map<String, String> configOverrides = super.getConfigOverrides();
            return ImmutableMap.builder().putAll(configOverrides).put((Object)"stargate.metrics.tenant-request-counter.user-agent-tag", (Object)"agentTag").put((Object)"stargate.metrics.tenant-request-counter.user-agent-tag-enabled", (Object)"true").build();
        }
    }
}

