/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.token.configuration;

import io.quarkus.arc.lookup.LookupIfProperty;
import io.stargate.sgv2.api.common.config.AuthConfig;
import io.stargate.sgv2.api.common.token.CassandraTokenResolver;
import io.stargate.sgv2.api.common.token.impl.FixedTokenResolver;
import io.stargate.sgv2.api.common.token.impl.HeaderTokenResolver;
import io.stargate.sgv2.api.common.token.impl.PrincipalTokenResolver;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.Optional;

public class CassandraTokenConfiguration {
    @Produces
    @ApplicationScoped
    @LookupIfProperty(name="stargate.auth.token-resolver.type", stringValue="header")
    CassandraTokenResolver headerTokenResolver(AuthConfig config) {
        String headerName = config.tokenResolver().header().headerName();
        return new HeaderTokenResolver(headerName);
    }

    @Produces
    @ApplicationScoped
    @LookupIfProperty(name="stargate.auth.token-resolver.type", stringValue="principal")
    CassandraTokenResolver principalTokenResolver() {
        return new PrincipalTokenResolver();
    }

    @Produces
    @ApplicationScoped
    @LookupIfProperty(name="stargate.auth.token-resolver.type", stringValue="fixed")
    CassandraTokenResolver fixedTokenResolver(AuthConfig config) {
        return new FixedTokenResolver(config.tokenResolver().fixed());
    }

    @Produces
    @ApplicationScoped
    @LookupIfProperty(name="stargate.auth.token-resolver.type", stringValue="noop", lookupIfMissing=true)
    CassandraTokenResolver noopCassandraTokenResolver() {
        return (context, securityContext) -> Optional.empty();
    }
}

