/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.smallrye.mutiny.helpers.test.UniAssertSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.StargateBridgeGrpc;
import io.stargate.sgv2.api.common.grpc.RetriableStargateBridge;
import io.stargate.sgv2.api.common.grpc.qualifier.Retriable;
import io.stargate.sgv2.common.bridge.BridgeTest;
import io.stargate.sgv2.common.testprofiles.NoGlobalResourcesTestProfile;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
@TestProfile(value=Profile.class)
class RetriableStargateBridgeDisabledTest
extends BridgeTest {
    @Retriable
    @Inject
    RetriableStargateBridge bridge;

    RetriableStargateBridgeDisabledTest() {
    }

    @Test
    public void disabledNoRetries() {
        ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.doAnswer(invocationOnMock -> {
            StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
            Status status = Status.UNAVAILABLE;
            observer.onError((Throwable)new StatusRuntimeException(status));
            return null;
        }).when((Object)this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.any(), (StreamObserver)ArgumentMatchers.any());
        QueryOuterClass.Query request = QueryOuterClass.Query.newBuilder().build();
        Throwable result = ((UniAssertSubscriber)this.bridge.executeQuery(request).subscribe().withSubscriber((UniSubscriber)UniAssertSubscriber.create())).awaitFailure().getFailure();
        Assertions.assertThat((Throwable)result).isInstanceOfSatisfying(StatusRuntimeException.class, e -> Assertions.assertThat((Object)e.getStatus()).isEqualTo((Object)Status.UNAVAILABLE));
        ((StargateBridgeGrpc.StargateBridgeImplBase)Mockito.verify((Object)this.bridgeService)).executeQuery((QueryOuterClass.Query)ArgumentMatchers.eq((Object)request), (StreamObserver)ArgumentMatchers.any());
    }

    public static class Profile
    implements NoGlobalResourcesTestProfile {
        public Map<String, String> getConfigOverrides() {
            return ImmutableMap.builder().put((Object)"stargate.grpc.retries.enabled", (Object)"false").put((Object)"stargate.grpc.retries.status-codes", (Object)"UNAVAILABLE,NOT_FOUND").build();
        }
    }
}

