/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.cql;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Or;
import java.util.List;

public class ExpressionUtils<K> {
    public static <K> And<K> andOf(Expression<K> ... expressions) {
        return And.of(expressions, (e1, e2) -> 1);
    }

    public static <K> And<K> andOf(List<? extends Expression<K>> expressions) {
        return And.of((Expression[])expressions.toArray(new Expression[expressions.size()]), (e1, e2) -> 1);
    }

    public static <K> Or<K> orOf(List<? extends Expression<K>> expressions) {
        return Or.of((Expression[])expressions.toArray(new Expression[expressions.size()]), (e1, e2) -> 1);
    }

    public static <K> Or<K> orOf(Expression<K> ... expressions) {
        return Or.of(expressions, (e1, e2) -> 1);
    }

    public static <K> Expression<K> buildExpression(List<? extends Expression<K>> expressions, String logicOperator) {
        switch (logicOperator) {
            case "$and": {
                return ExpressionUtils.andOf(expressions);
            }
            case "$or": {
                return ExpressionUtils.orOf(expressions);
            }
        }
        return null;
    }

    public static <K> Expression<K>[] getAsArray(Expression<K> ... expressions) {
        return expressions;
    }
}

