/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.api.common.exception;

import io.quarkus.arc.lookup.LookupIfProperty;
import io.stargate.sgv2.api.common.exception.model.dto.ApiError;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LookupIfProperty(name="stargate.exception-mappers.enabled", stringValue="true", lookupIfMissing=true)
public class RuntimeExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionMapper.class);

    @ServerExceptionMapper
    public RestResponse<ApiError> runtimeException(RuntimeException exception) {
        log.error("Unexpected runtime exception occurred.", (Throwable)exception);
        int code = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        ApiError error = new ApiError(exception.getMessage(), code);
        return RestResponse.ResponseBuilder.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)error).build();
    }
}

