/*
 * Decompiled with CFR 0.152.
 */
package io.stepuplabs.spaydkmp.common;

import io.stepuplabs.spaydkmp.exception.ValidationException;
import io.stepuplabs.spaydkmp.formatter.Formatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lio/stepuplabs/spaydkmp/common/IBAN;", "", "<init>", "()V", "createForCzechAccount", "", "prefix", "", "account", "bank", "(Ljava/lang/Long;JJ)Ljava/lang/String;", "validateEleven", "", "value", "shared_release"})
public final class IBAN {
    @NotNull
    public final String createForCzechAccount(@Nullable Long prefix, long account, long bank) throws ValidationException {
        boolean isValid = true;
        if (prefix != null) {
            isValid = this.validateEleven(prefix);
        }
        boolean bl = isValid = isValid && this.validateEleven(account);
        if (!isValid) {
            throw new ValidationException("Account prefix & number: Invalid value");
        }
        Object[] objectArray = new Object[1];
        Long l = prefix;
        objectArray[0] = l != null ? l : 0L;
        String prefixFormatted = Formatter.Companion.format("%06d", objectArray);
        Object[] objectArray2 = new Object[]{account};
        String accountFormatted = Formatter.Companion.format("%010d", objectArray2);
        Object[] objectArray3 = new Object[]{bank};
        String bankFormatted = Formatter.Companion.format("%04d", objectArray3);
        String buf = bankFormatted + prefixFormatted + accountFormatted + "123500";
        int index = 0;
        Object dividend = null;
        int checksum = -1;
        while (index <= buf.length()) {
            if (checksum < 0) {
                Intrinsics.checkNotNullExpressionValue((Object)buf.substring(index, (int)Math.min((double)(index + 9), (double)buf.length())), (String)"substring(...)");
                index += 9;
            } else {
                boolean bl2 = 0 <= checksum ? checksum < 10 : false;
                if (bl2) {
                    String string = buf.substring(index, (int)Math.min((double)(index + 8), (double)buf.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    dividend = checksum + string;
                    index += 8;
                } else {
                    String string = buf.substring(index, (int)Math.min((double)(index + 7), (double)buf.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    dividend = checksum + string;
                    index += 7;
                }
            }
            checksum = Integer.parseInt((String)dividend) % 97;
        }
        checksum = 98 - checksum;
        Object[] objectArray4 = new Object[]{checksum};
        String accountForIban = Formatter.Companion.format("%02d", objectArray4) + bankFormatted + prefixFormatted + accountFormatted;
        return "CZ" + accountForIban;
    }

    private final boolean validateEleven(long value) {
        String number = String.valueOf(value);
        int weight = 1;
        int sum = 0;
        int n = number.length() - 1;
        if (0 <= n) {
            do {
                int i = n--;
                sum += (number.charAt(i) - 48) * weight;
                weight *= 2;
            } while (0 <= n);
        }
        return sum % 11 == 0;
    }
}

