/*
 * Decompiled with CFR 0.152.
 */
package io.stepuplabs.spaydkmp.common;

import com.ionspin.kotlin.bignum.decimal.BigDecimal;
import io.stepuplabs.spaydkmp.common.BankAccount;
import io.stepuplabs.spaydkmp.common.BankAccountList;
import io.stepuplabs.spaydkmp.common.Key;
import io.stepuplabs.spaydkmp.common.NotificationType;
import io.stepuplabs.spaydkmp.common.PaymentType;
import io.stepuplabs.spaydkmp.exception.ValidationException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\nH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lio/stepuplabs/spaydkmp/common/Validator;", "", "<init>", "()V", "validate", "", "value", "key", "Lio/stepuplabs/spaydkmp/common/Key;", "digitsOf", "", "", "shared_release"})
public final class Validator {
    public final boolean validate(@NotNull Object value, @NotNull Key key) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        if (!key.getType().isInstance(value)) {
            throw new ValidationException("Value class is incorrect. Is: " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + ", should be: " + key.getType().getSimpleName());
        }
        KClass<?> kClass = key.getType();
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            return true;
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BankAccount.class))) {
            return true;
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(NotificationType.class))) {
            return true;
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(PaymentType.class))) {
            return true;
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            double it;
            int typedValue = (Integer)value;
            Double d = key.getMinValue();
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl = false;
                if ((double)typedValue < it) {
                    throw new ValidationException(key + " is lower than allowed minimum value (" + it + ")");
                }
            }
            Double d2 = key.getMaxValue();
            if (d2 != null) {
                it = ((Number)d2).doubleValue();
                boolean bl = false;
                if ((double)typedValue > it) {
                    throw new ValidationException(key + " is higher than allowed maximum value (" + it + ")");
                }
            }
            Integer n = key.getMinLength();
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl = false;
                if (this.digitsOf(typedValue) < it2) {
                    throw new ValidationException(key + " is shorter than allowed minimum length (" + it2 + ")");
                }
            }
            Integer n2 = key.getMaxLength();
            if (n2 != null) {
                int it3 = ((Number)n2).intValue();
                boolean bl = false;
                if (this.digitsOf(typedValue) > it3) {
                    throw new ValidationException(key + " is longer than allowed maximum length (" + it3 + ")");
                }
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            double it;
            long typedValue = (Long)value;
            Double d = key.getMinValue();
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl = false;
                if ((double)typedValue < it) {
                    throw new ValidationException(key + " is lower than allowed minimum value (" + it + ")");
                }
            }
            Double d3 = key.getMaxValue();
            if (d3 != null) {
                it = ((Number)d3).doubleValue();
                boolean bl = false;
                if ((double)typedValue > it) {
                    throw new ValidationException(key + " is higher than allowed maximum value (" + it + ")");
                }
            }
            Integer n = key.getMinLength();
            if (n != null) {
                int it4 = ((Number)n).intValue();
                boolean bl = false;
                if (this.digitsOf(typedValue) < it4) {
                    throw new ValidationException(key + " is shorter than allowed minimum length (" + it4 + ")");
                }
            }
            Integer n3 = key.getMaxLength();
            if (n3 != null) {
                int it5 = ((Number)n3).intValue();
                boolean bl = false;
                if (this.digitsOf(typedValue) > it5) {
                    throw new ValidationException(key + " is longer than allowed maximum length (" + it5 + ")");
                }
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            double it;
            double typedValue = (Double)value;
            Double d = key.getMinValue();
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl = false;
                if (typedValue < it) {
                    throw new ValidationException(key + " is lower than allowed minimum value (" + it + ")");
                }
            }
            Double d4 = key.getMaxValue();
            if (d4 != null) {
                it = ((Number)d4).doubleValue();
                boolean bl = false;
                if (typedValue > it) {
                    throw new ValidationException(key + " is higher than allowed maximum value (" + it + ")");
                }
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            double it;
            BigDecimal typedValue = (BigDecimal)value;
            Double d = key.getMinValue();
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl = false;
                if (typedValue.compareTo((Object)it) < 0) {
                    throw new ValidationException(key + " is lower than allowed minimum value (" + it + ")");
                }
            }
            Double d5 = key.getMaxValue();
            if (d5 != null) {
                it = ((Number)d5).doubleValue();
                boolean bl = false;
                if (typedValue.compareTo((Object)it) > 0) {
                    throw new ValidationException(key + " is higher than allowed maximum value (" + it + ")");
                }
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            int it;
            String typedValue = (String)value;
            Integer n = key.getMinLength();
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                if (typedValue.length() < it) {
                    throw new ValidationException(key + " is shorter than allowed minimum length (" + it + ")");
                }
            }
            Integer n4 = key.getMaxLength();
            if (n4 != null) {
                it = ((Number)n4).intValue();
                boolean bl = false;
                if (typedValue.length() > it) {
                    throw new ValidationException(key + " is longer than allowed maximum length (" + it + ")");
                }
            }
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BankAccountList.class))) {
            int it;
            BankAccountList typedValue = (BankAccountList)value;
            Integer n = key.getMinLength();
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                if (((Collection)typedValue.getBankAccounts()).size() < it) {
                    throw new ValidationException(key + " is shorter than allowed minimum length (" + it + ")");
                }
            }
            Integer n5 = key.getMaxLength();
            if (n5 != null) {
                it = ((Number)n5).intValue();
                boolean bl = false;
                if (((Collection)typedValue.getBankAccounts()).size() > it) {
                    throw new ValidationException(key + " is longer than allowed maximum length (" + it + ")");
                }
            }
        } else {
            throw new ValidationException("Unsupported type of " + key);
        }
        return true;
    }

    private final int digitsOf(int value) {
        return (int)Math.log10(value) + 1;
    }

    private final int digitsOf(long value) {
        return (int)Math.log10(value) + 1;
    }
}

