/*
 * Decompiled with CFR 0.152.
 */
package io.stepuplabs.spaydkmp.formatter;

import io.stepuplabs.spaydkmp.formatter.CharArrayBuffer;
import io.stepuplabs.spaydkmp.formatter.FormatToken;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lio/stepuplabs/spaydkmp/formatter/ParserStateMachine;", "", "format", "Lio/stepuplabs/spaydkmp/formatter/CharArrayBuffer;", "<init>", "(Lio/stepuplabs/spaydkmp/formatter/CharArrayBuffer;)V", "nextFormatToken", "Lio/stepuplabs/spaydkmp/formatter/FormatToken;", "getNextFormatToken", "()Lio/stepuplabs/spaydkmp/formatter/FormatToken;", "token", "state", "", "currentChar", "", "nextFormatChar", "getNextFormatChar", "()C", "formatString", "", "getFormatString", "()Ljava/lang/String;", "reset", "", "processEntryState", "processStartConversionState", "processFlagsState", "processWidthState", "processPrecisionState", "processConversionTypeState", "processSuffixState", "processExitState", "parseInt", "buffer", "Companion", "shared_release"})
public final class ParserStateMachine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharArrayBuffer format;
    @Nullable
    private FormatToken token;
    private int state;
    private char currentChar;
    private static final char EOS = '\uffff';
    private static final int EXIT_STATE = 0;
    private static final int ENTRY_STATE = 1;
    private static final int START_CONVERSION_STATE = 2;
    private static final int FLAGS_STATE = 3;
    private static final int WIDTH_STATE = 4;
    private static final int PRECISION_STATE = 5;
    private static final int CONVERSION_TYPE_STATE = 6;
    private static final int SUFFIX_STATE = 7;

    public ParserStateMachine(@NotNull CharArrayBuffer format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        this.state = 1;
    }

    @NotNull
    public final FormatToken getNextFormatToken() {
        FormatToken formatToken = this.token = new FormatToken();
        Intrinsics.checkNotNull((Object)formatToken);
        formatToken.setFormatStringStartIndex(this.format.position());
        block10: while (true) {
            if (this.state != 0) {
                this.currentChar = this.getNextFormatChar();
                if ('\uffff' == this.currentChar && 1 != this.state) {
                    throw new Exception(this.getFormatString());
                }
            }
            switch (this.state) {
                case 0: {
                    this.processExitState();
                    FormatToken formatToken2 = this.token;
                    Intrinsics.checkNotNull((Object)formatToken2, (String)"null cannot be cast to non-null type io.stepuplabs.spaydkmp.formatter.FormatToken");
                    return formatToken2;
                }
                case 1: {
                    this.processEntryState();
                    continue block10;
                }
                case 2: {
                    this.processStartConversionState();
                    continue block10;
                }
                case 3: {
                    this.processFlagsState();
                    continue block10;
                }
                case 4: {
                    this.processWidthState();
                    continue block10;
                }
                case 5: {
                    this.processPrecisionState();
                    continue block10;
                }
                case 6: {
                    this.processConversionTypeState();
                    continue block10;
                }
                case 7: {
                    this.processSuffixState();
                }
            }
        }
    }

    private final char getNextFormatChar() {
        return this.format.hasRemaining() ? this.format.get() : (char)'\uffff';
    }

    private final String getFormatString() {
        int end = this.format.position();
        this.format.rewind();
        FormatToken formatToken = this.token;
        Intrinsics.checkNotNull((Object)formatToken);
        String formatString = this.format.subSequence(formatToken.getFormatStringStartIndex(), end).toString();
        this.format.position(end);
        return formatString;
    }

    public final void reset() {
        this.currentChar = (char)65535;
        this.state = 1;
        this.token = null;
    }

    private final void processEntryState() {
        if ('\uffff' == this.currentChar) {
            this.state = 0;
        } else if ('%' == this.currentChar) {
            this.state = 2;
        }
    }

    private final void processStartConversionState() {
        if (Character.isDigit(this.currentChar)) {
            int position = this.format.position() - 1;
            int number = this.parseInt(this.format);
            int nextChar = 0;
            if (this.format.hasRemaining()) {
                nextChar = this.format.get();
            }
            if (36 == nextChar) {
                if (number > 0) {
                    FormatToken formatToken = this.token;
                    Intrinsics.checkNotNull((Object)formatToken);
                    formatToken.setArgIndex(number - 1);
                } else if (number == -1) {
                    throw new Exception(this.getFormatString());
                }
                this.state = 3;
            } else if ('0' == this.currentChar) {
                this.state = 3;
                this.format.position(position);
            } else {
                this.state = 4;
                this.format.position(this.format.position() - 1);
                FormatToken formatToken = this.token;
                Intrinsics.checkNotNull((Object)formatToken);
                formatToken.setWidth(number);
            }
            this.currentChar = (char)nextChar;
        } else if ('<' == this.currentChar) {
            this.state = 3;
            FormatToken formatToken = this.token;
            Intrinsics.checkNotNull((Object)formatToken);
            formatToken.setArgIndex(-2);
        } else {
            this.state = 3;
            this.format.position(this.format.position() - 1);
        }
    }

    private final void processFlagsState() {
        FormatToken formatToken = this.token;
        Intrinsics.checkNotNull((Object)formatToken);
        if (!formatToken.setFlag(this.currentChar)) {
            if (Character.isDigit(this.currentChar)) {
                FormatToken formatToken2 = this.token;
                Intrinsics.checkNotNull((Object)formatToken2);
                formatToken2.setWidth(this.parseInt(this.format));
                this.state = 4;
            } else if ('.' == this.currentChar) {
                this.state = 5;
            } else {
                this.state = 6;
                this.format.position(this.format.position() - 1);
            }
        }
    }

    private final void processWidthState() {
        if ('.' == this.currentChar) {
            this.state = 5;
        } else {
            this.state = 6;
            this.format.position(this.format.position() - 1);
        }
    }

    private final void processPrecisionState() {
        if (!Character.isDigit(this.currentChar)) {
            throw new Exception(this.getFormatString());
        }
        FormatToken formatToken = this.token;
        Intrinsics.checkNotNull((Object)formatToken);
        formatToken.setPrecision(this.parseInt(this.format));
        this.state = 6;
    }

    private final void processConversionTypeState() {
        FormatToken formatToken = this.token;
        Intrinsics.checkNotNull((Object)formatToken);
        formatToken.setConversionType(this.currentChar);
        this.state = 't' == this.currentChar || 'T' == this.currentChar ? 7 : 0;
    }

    private final void processSuffixState() {
        FormatToken formatToken = this.token;
        Intrinsics.checkNotNull((Object)formatToken);
        formatToken.setDateSuffix(this.currentChar);
        this.state = 0;
    }

    private final void processExitState() {
        FormatToken formatToken = this.token;
        Intrinsics.checkNotNull((Object)formatToken);
        formatToken.setPlainText(this.getFormatString());
    }

    private final int parseInt(CharArrayBuffer buffer) {
        int n;
        int start = buffer.position() - 1;
        int end = buffer.limit();
        while (buffer.hasRemaining()) {
            if (Character.isDigit(buffer.get())) continue;
            end = buffer.position() - 1;
            break;
        }
        buffer.position(0);
        String intStr = buffer.subSequence(start, end).toString();
        buffer.position(end);
        try {
            n = Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        return n;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/stepuplabs/spaydkmp/formatter/ParserStateMachine$Companion;", "", "<init>", "()V", "EOS", "", "EXIT_STATE", "", "ENTRY_STATE", "START_CONVERSION_STATE", "FLAGS_STATE", "WIDTH_STATE", "PRECISION_STATE", "CONVERSION_TYPE_STATE", "SUFFIX_STATE", "shared_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

